<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item"><a href="<?php echo site_url('diagnostic/template/option'); ?>"><?php echo $this->lang->line('test_option'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo isset($option) ? $this->lang->line('edit') : $this->lang->line('add'); ?> <?php echo $this->lang->line('test_option'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-<?php echo isset($option) ? 'edit' : 'plus'; ?>"></i></span>
            <?php echo isset($option) ? $this->lang->line('edit') : $this->lang->line('add'); ?> <?php echo $this->lang->line('test_option'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('diagnostic/template/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'diagnostic', 'template')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-<?php echo isset($option) ? 'edit' : 'plus'; ?> font-30 mr-10"></i>
                            <?php echo isset($option) ? $this->lang->line('edit') : $this->lang->line('add'); ?> <?php echo $this->lang->line('test_option'); ?>
                        </h6>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('diagnostic/template/' . (isset($option) ? 'option_edit/'.$option->id : 'option_add')), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <?php if(isset($option)){ ?>
                    <input type="hidden" name="id" value="<?php echo $option->id; ?>" />
                <?php } ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="test_id"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('test'); ?></label>
                            <select class="form-control custom-select select2" name="test_id" id="test_id" required>
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($tests as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo (isset($option) && $option->test_id == $obj->id) || (isset($test_id) && $test_id == $obj->id) ? 'selected="selected"' : ''; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="template_id"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('template'); ?></label>
                            <select class="form-control custom-select select2" name="template_id" id="template_id" required>
                                <option value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($templates as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo (isset($option) && $option->template_id == $obj->id) || (isset($template_id) && $template_id == $obj->id) ? 'selected="selected"' : ''; ?>><?php echo $obj->investigation; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="option_name"><?php echo $this->lang->line('option_name'); ?></label>
                            <input type="text" class="form-control" name="option_name" id="option_name" value="<?php echo isset($option) ? $option->option_name : (isset($option_name) ? $option_name : ''); ?>" placeholder="<?php echo $this->lang->line('option_name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo (isset($option) && $option->status == 1) || (!isset($option) && !isset($status)) ? 'checked' : (isset($status) && $status == 1 ? 'checked' : ''); ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('diagnostic/template/option'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($option) ? $this->lang->line('update') : $this->lang->line('save'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: 42px !important;
        border: 1px solid rgba(33, 33, 33, 0.12);
        border-radius: 6px;
    }
    .select2-container--default .select2-selection--single {
        background-color: #fff;
        border-color: rgba(33, 33, 33, 0.12);
    }
    .select2-container--default .select2-selection--single .select2-selection__rendered {
        color: #324148;
        line-height: 42px;
        padding-left: 15px;
    }
    .select2-container--default .select2-selection--single .select2-selection__arrow {
        height: 42px;
        right: 10px;
    }
    .select2-container--default .select2-selection--single .select2-selection__placeholder {
        color: #999;
    }
    .select2-container--default.select2-container--open .select2-selection--single {
        border-color: #0088ff;
    }
    .select2-container--default .select2-search--dropdown .select2-search__field {
        border: 1px solid rgba(33, 33, 33, 0.12);
        border-radius: 4px;
        padding: 8px 15px;
    }
    .select2-dropdown {
        border: 1px solid rgba(33, 33, 33, 0.12);
        border-radius: 6px;
    }
    .select2-results__option {
        padding: 8px 15px;
        color: #324148;
    }
    .select2-container--default .select2-results__option--highlighted[aria-selected] {
        background-color: #0088ff;
    }
    .select2-container--default .select2-results__option[aria-selected=true] {
        background-color: #f5f5f5;
    }
    .form-control.is-invalid + .select2-container .select2-selection--single {
        border-color: #dc3545;
    }
    .form-control.is-valid + .select2-container .select2-selection--single {
        border-color: #28a745;
    }
</style>

<script>
    $(".select2").select2({
        placeholder: "<?php echo $this->lang->line('select'); ?>",
        allowClear: true,
        width: '100%'
    });

    // When test is selected, load related templates
    $('#test_id').on('change', function() {
        var test_id = $(this).val();
        if(test_id) {
            $.ajax({
                type: "POST",
                url: "<?php echo site_url('diagnostic/template/get_test_templates'); ?>",
                data: {
                    test_id: test_id
                },
                async: false,
                beforeSend: function() {
                    $('#template_id').html('<option value=""><?php echo $this->lang->line('loading'); ?>...</option>');
                },
                success: function(response) {
                    if (response) {
                        $('#template_id').html(response);
                    } else {
                        $('#template_id').html('<option value=""><?php echo $this->lang->line('select'); ?></option>');
                    }
                },
                error: function() {
                    $('#template_id').html('<option value=""><?php echo $this->lang->line('select'); ?></option>');
                }
            });
        } else {
            $('#template_id').html('<option value=""><?php echo $this->lang->line('select'); ?></option>');
        }
    });

    // Trigger change event if test is already selected (for edit mode)
    <?php if(isset($option) && $option->test_id) { ?>
        $('#test_id').trigger('change');
        // Set the template value after templates are loaded
        setTimeout(function() {
            $('#template_id').val('<?php echo $option->template_id; ?>').trigger('change');
        }, 100);
    <?php } ?>
</script> 