<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('help'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('help'); ?> <?php echo $this->lang->line('info'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-map-marker font-30 mr-10"></i>
                        <?php echo $this->lang->line('contact_us'); ?>
                    </h6>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush text-primary">
                        <li class="list-group-item d-flex align-items-center">
                            <i class="fa fa-map-marker mr-15  text-teal"></i>
                            Narkeltola More, Satkhira-9400, Khulna, Bangladesh
                        </li>
                        <li class="list-group-item d-flex align-items-center">
                            <i class="fa fa-phone mr-15 text-teal"></i>
                            <a href="tel:+8801751199433">+8801751 199433</a>
                        </li>
                        <li class="list-group-item d-flex align-items-center">
                            <i class="fa fa-envelope-o mr-15 text-teal"></i>
                            <a href="mailto:info@sbitzone.com">info@sbitzone.com</a>
                        </li>
                        <li class="list-group-item d-flex align-items-center">
                            <i class="fa fa-skype mr-15 text-teal"></i>
                            <a href="skype:sbitzone?chat">sbitzone</a>
                        </li>
                        <li class="list-group-item d-flex align-items-center">
                            <i class="fa fa-globe mr-15 text-teal"></i>
                            <a href="http://sbitzone.com" target="_blank">www.sbitzone.com</a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <!-- col-xl-8 -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-envelope font-30 mr-10"></i>
                        <?php echo $this->lang->line('send'); ?> <?php echo $this->lang->line('message'); ?>
                    </h6>
                </div>
                <?php echo form_open_multipart(site_url('setting/support'), array('name' => 'support', 'id' => 'support', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <input type="hidden" value="support" name="support" />
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="email" class="form-control" name="email" id="email" value="<?php echo isset($email) ?  $email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="subject"><?php echo $this->lang->line('subject'); ?></label>
                            <input type="text" class="form-control" name="subject" id="subject" value="<?php echo isset($subject) ?  $subject : ''; ?>" placeholder="<?php echo $this->lang->line('subject'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-12 mb-10">
                            <div class="tinymce-wrap">
                                <textarea class="tinymce" name="message" id="message" required><?php echo isset($message) ?  $message : ''; ?></textarea>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('send'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<script>
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 200,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
        });
    });
</script>