<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('setting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('setting'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('setting/left-side'); ?>
        <!-- col-xl-8 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h6 class="card-header d-flex align-items-center">
                        <i class="fa fa-commenting-o font-30 mr-10"></i>
                        <?php echo $this->lang->line('sms'); ?> <?php echo $this->lang->line('setting'); ?>
                    </h6>
                    <div class="align-items-center">
                        <a href="<?php echo site_url('dashboard'); ?>" class="btn btn-xs btn-primary">
                            <i class="fa fa-dashboard"></i>
                            <?php echo $this->lang->line('dashboard'); ?>
                        </a>
                    </div>
                </div>
                <?php $action = isset($sms_settings) ? 'edit' : 'add'; ?>
                <?php echo form_open_multipart(site_url('setting/smssetting/' . $action), array('name' => 'setting', 'id' => 'setting', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <input type="hidden" value="<?php echo isset($sms_settings) ? $sms_settings->id : ''; ?>" name="id" />
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="mimsms_api_key"><?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('api_key'); ?></label>
                            <input type="text" class="form-control" name="mimsms_api_key" id="mimsms_api_key" value="<?php echo isset($sms_settings) ?  $sms_settings->mimsms_api_key : ''; ?>" placeholder="<?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('api_key'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="mimsms_type"><?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select d-block w-100" name="mimsms_type" id="mimsms_type" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <option value="text" <?php echo $sms_settings->mimsms_type == 'text' ? 'selected' : ''; ?>><?php echo $this->lang->line('text'); ?></option>
                                <option value="unicode" <?php echo $sms_settings->mimsms_type == 'unicode' ? 'selected' : ''; ?>><?php echo $this->lang->line('unicode'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="mimsms_sender_id"><?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('sender_id'); ?></label>
                            <input type="text" class="form-control" name="mimsms_sender_id" id="mimsms_sender_id" value="<?php echo isset($sms_settings) ?  $sms_settings->mimsms_sender_id : ''; ?>" placeholder="<?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('sender_id'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="mimsms_status"><?php echo $this->lang->line('mim_sms'); ?> <?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select d-block w-100" name="mimsms_status" id="mimsms_status" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <option value="1" <?php echo $sms_settings->mimsms_status == '1' ? 'selected' : ''; ?>><?php echo $this->lang->line('yes'); ?></option>
                                <option value="0" <?php echo $sms_settings->mimsms_status == '0' ? 'selected' : ''; ?>><?php echo $this->lang->line('no'); ?></option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="price"><?php echo $this->lang->line('price'); ?></label>
                            <input type="text" class="form-control" name="price" id="price" value="<?php echo isset($sms_settings) ?  $sms_settings->price : ''; ?>" placeholder="<?php echo $this->lang->line('price'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $action == 'add' ? $this->lang->line('submit') : $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>
<!-- /Container -->