<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('visitor'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_visitor'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/mis/visitor'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="form-row">
                            <div class="col-md-2 mb-10">
                                <label for="search"><?php echo $this->lang->line('keyword'); ?></label>
                                <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="date"><?php echo $this->lang->line('date'); ?></label>
                                <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Pregnancy</label>
                                <select class="form-control custom-select" name="pregnancy" id="pregnancy">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('pregnancy'); ?></option>
                                    <option value="yes" <?php echo isset($pregnancy) && $pregnancy == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($pregnancy) && $pregnancy == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Emergency Treatment</label>
                                <select class="form-control custom-select" name="treatment" id="treatment">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('treatment'); ?></option>
                                    <option value="yes" <?php echo isset($treatment) && $treatment == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($treatment) && $treatment == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Health Card</label>
                                <select class="form-control custom-select" name="card" id="card">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('card'); ?></option>
                                    <option value="yes" <?php echo isset($card) && $card == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($card) && $card == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Health Package</label>
                                <select class="form-control custom-select" name="package" id="package">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('package'); ?></option>
                                    <option value="yes" <?php echo isset($package) && $package == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($package) && $package == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Land</label>
                                <select class="form-control custom-select" name="land" id="land">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('land'); ?></option>
                                    <option value="yes" <?php echo isset($land) && $land == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($land) && $land == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Operation</label>
                                <select class="form-control custom-select" name="operation" id="operation">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('operation'); ?></option>
                                    <option value="yes" <?php echo isset($operation) && $operation == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($operation) && $operation == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-10">
                                <label for="land">Lab Test</label>
                                <select class="form-control custom-select" name="test" id="test">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('test'); ?></option>
                                    <option value="yes" <?php echo isset($test) && $test == 'yes' ? 'selected="selected"' : ""; ?>>Yes</option>
                                    <option value="no" <?php echo isset($test) && $test == 'no' ? 'selected="selected"' : ""; ?>>No</option>
                                </select>
                            </div>
                            <div class="col-md-3 mb-10">
                                <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                                <select class="form-control custom-select select2" name="created_by" id="created_by">
                                    <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                    <?php foreach ($employees as $obj) { ?>
                                        <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
            <?php if ($_GET) { ?>
                <!-- Report Details -->
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                                <h6 class="card-header d-flex align-items-center">
                                    <i class="fa fa-exchange font-30 mr-10"></i>
                                    <?php echo $this->lang->line('visitor'); ?> <?php echo $this->lang->line('report'); ?>
                                </h6>
                            <?php } ?>
                            <div class="button-list">
                                <a target="_blank" href="<?php echo site_url('report/mis/visitor_pdf/?search=' . $search . '&date=' . $date . '&pregnancy=' . $pregnancy . '&treatment=' . $treatment . '&card=' . $card . '&package=' . $package . '&land=' . $land . '&operation=' . $operation . '&test=' . $test . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                    <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-wrap">
                                <div class="table-responsive">
                                    <table class="table table-sm mb-0">
                                        <thead>
                                            <tr>
                                                <th>SL No</th>
                                                <th>Emp. Name</th>
                                                <th>Total Visit</th>
                                                <th>Family Patient</th>
                                                <th>Pregnancy</th>
                                                <th>Emergency</th>
                                                <th>Health Card</th>
                                                <th>Health Package</th>
                                                <th>Medicine</th>
                                                <th>Land</th>
                                                <th>Lab Test</th>
                                                <th>Surgery</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $count = 1;
                                            $total_visit = 0;
                                            $total_family_patient = 0;
                                            $total_emergency = 0;
                                            $total_pregnancy = 0;
                                            $total_health_card = 0;
                                            $total_health_package = 0;
                                            $total_medicine = 0;
                                            $total_land = 0;
                                            $total_test = 0;
                                            $total_surgery = 0;
                                            if (isset($visitors) && !empty($visitors)) { ?>
                                                <?php foreach ($visitors as $obj) {
                                                    $total_visit += $obj->total_visit;
                                                    $total_family_patient += $obj->total_family_patient;
                                                    $total_emergency += $obj->total_emergency;
                                                    $total_pregnancy += $obj->total_pregnancy;
                                                    $total_health_card += $obj->total_health_card;
                                                    $total_health_package += $obj->total_health_package;
                                                    $total_medicine += $obj->total_medicine;
                                                    $total_land += $obj->total_land;
                                                    $total_test += $obj->total_test;
                                                    $total_surgery += $obj->total_surgery;
                                                ?>
                                                    <tr>
                                                        <td><?php echo $count++; ?></td>
                                                        <td><?php echo $obj->created_by; ?></td>
                                                        <td><?php echo $obj->total_visit; ?></td>
                                                        <td><?php echo $obj->total_family_patient; ?></td>
                                                        <td><?php echo $obj->total_emergency; ?></td>
                                                        <td><?php echo $obj->total_pregnancy; ?></td>
                                                        <td><?php echo $obj->total_health_card; ?></td>
                                                        <td><?php echo $obj->total_health_package; ?></td>
                                                        <td><?php echo $obj->total_medicine; ?></td>
                                                        <td><?php echo $obj->total_land; ?></td>
                                                        <td><?php echo $obj->total_test; ?></td>
                                                        <td><?php echo $obj->total_surgery; ?></td>
                                                    </tr>
                                                <?php } ?>
                                            <?php } ?>
                                        </tbody>
                                        <tfoot>
                                            <tr>
                                                <td colspan="2"></td>
                                                <td><?php echo $total_visit; ?></td>
                                                <td><?php echo $total_family_patient; ?></td>
                                                <td><?php echo $total_emergency; ?></td>
                                                <td><?php echo $total_pregnancy; ?></td>
                                                <td><?php echo $total_health_card; ?></td>
                                                <td><?php echo $total_health_package; ?></td>
                                                <td><?php echo $total_medicine; ?></td>
                                                <td><?php echo $total_land; ?></td>
                                                <td><?php echo $total_test; ?></td>
                                                <td><?php echo $total_surgery; ?></td>
                                            </tr>
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
        <!-- /Row -->
    </div>
    <!-- /Container -->
    <!-- Daterangepicker -->
    <link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
    <script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

    <!-- Select2 -->
    <link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
    <script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

    <style>
        .select2-container .select2-selection--single {
            height: calc(2.25rem + 4px) !important;
        }

        .select2-container--default .select2-search--dropdown .select2-search__field {
            color: #324148;
            border-width: 2px;
            border-color: #e0e3e4;
            padding: .375rem .75rem;
            height: calc(2.25rem + 4px);
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow b {
            margin-top: 5px;
        }
    </style>
    <script>
        $(document).ready(function() {
            $(".select2").select2();

            $('#range').daterangepicker({
                autoUpdateInput: false,
                startDate: new Date(),
                endDate: moment(),
                showDropdowns: true,
                minYear: 1901,
                locale: {
                    format: 'YYYY/MM/DD',
                },
                maxDate: moment().endOf('day'), // Limit to today's date
                maxSpan: {
                    "days": 31 // Limit the maximum span to 31 days
                },
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Tomorrow': [moment().add(1, 'days'), moment().add(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                }
            });

            $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
            });

            $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
            });
        });
    </script>