<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/billing'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/employee'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-3 mb-10">
                            <label for="keyword"><?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="keyword" id="keyword" value="<?php echo isset($keyword) ?  $keyword : ''; ?>" placeholder="<?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="role_id"><?php echo $this->lang->line('role'); ?></label>
                            <select class="form-control custom-select" name="role_id" id="role_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('role'); ?></option>
                                <?php foreach ($roles as $obj) { ?>
                                    <?php if ($this->session->userdata('role_id') != SUPER_ADMIN) { ?>
                                        <?php if (in_array($obj->id, array(SUPER_ADMIN, PATIENT))) {
                                            continue;
                                        } ?>
                                    <?php } ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($role_id) && $role_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="commission_type"><?php echo $this->lang->line('commission'); ?> <?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="commission_type" id="commission_type">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <option value="mbbs" <?php echo isset($commission_type) && $commission_type == 'mbbs' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('mbbs'); ?></option>
                                <option value="vd" <?php echo isset($commission_type) && $commission_type == 'vd' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('vd'); ?></option>
                                <option value="emp" <?php echo isset($commission_type) && $commission_type == 'emp' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('emp'); ?></option>
                                <option value="corporate" <?php echo isset($commission_type) && $commission_type == 'corporate' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('corporate'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="department_id"><?php echo $this->lang->line('department'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="department_id" id="department_id" onchange="get_designation(this.value)">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($departments as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="designation_id"><?php echo $this->lang->line('designation'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <select class="form-control custom-select select2" name="designation_id" id="designation_id">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                            <select class="form-control custom-select" name="gender" id="gender">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $genders = get_genders(); ?>
                                <?php foreach ($genders as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="religion"><?php echo $this->lang->line('religion'); ?></label>
                            <select class="form-control custom-select" name="religion" id="religion">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $religions = get_religion(); ?>
                                <?php foreach ($religions as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($religion) && $religion == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="blood_group"><?php echo $this->lang->line('blood_group'); ?></label>
                            <select class="form-control custom-select" name="blood_group" id="blood_group">
                                <option value="" selected><?php echo $this->lang->line('select'); ?></option>
                                <?php $bloods = get_blood_group(); ?>
                                <?php foreach ($bloods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($blood_group) && $blood_group == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($employees) && !empty($employees)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'appointment')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-user font-30 mr-10"></i>
                                <?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/employee/pdf/?keyword=' . $keyword . '&role_id=' . $role_id . '&commission_type=' . $commission_type . '&department_id=' . $department_id . '&designation_id=' . $designation_id . '&gender=' . $gender . '&religion=' . $religion . '&blood_group=' . $blood_group); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('employee'); ?> <?php echo $this->lang->line('id'); ?></th>
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('department'); ?></th>
                                            <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                                <th><?php echo $this->lang->line('specialist'); ?></th>
                                            <?php } else { ?>
                                                <th><?php echo $this->lang->line('designation'); ?></th>
                                            <?php } ?>
                                            <th><?php echo $this->lang->line('blood_group'); ?></th>
                                            <th><?php echo $this->lang->line('national_id'); ?></th>
                                            <th><?php echo $this->lang->line('phone'); ?></th>
                                            <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                                <th><?php echo $this->lang->line('first_fee'); ?></th>
                                                <th><?php echo $this->lang->line('second_fee'); ?></th>
                                                <th><?php echo $this->lang->line('hospital'); ?> <?php echo $this->lang->line('commission'); ?></th>
                                            <?php } ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        if (isset($employees) && !empty($employees)) { ?>
                                            <?php foreach ($employees as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->device_id; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $obj->department; ?></td>
                                                    <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                                        <td><?php echo $obj->specialist; ?></td>
                                                    <?php } else { ?>
                                                        <td><?php echo $obj->designation; ?></td>
                                                    <?php } ?>
                                                    <td><?php echo $this->lang->line($obj->blood_group); ?></td>
                                                    <td><?php echo $obj->national_id; ?></td>
                                                    <td><?php echo $obj->phone; ?></td>
                                                    <?php if (!empty($this->input->get('role_id')) && $this->input->get('role_id') == 3) { ?>
                                                        <td><?php echo $obj->first_fee; ?></td>
                                                        <td><?php echo $obj->second_fee; ?></td>
                                                        <td><?php echo $obj->hospital_commission; ?></td>
                                                    <?php } ?>
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr class="text-center">
                                                <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();

    function get_designation(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_department_by_designation'); ?>",
            data: {
                department_id: department_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#designation_id').html(response);
                }
            }
        });
    };
</script>