<!DOCTYPE html>
<html>

<head>
    <title>Diagnostic</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if ($this->input->get('department_id')) { ?>
                                    <b>Department:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $department->name; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>All Test:</b>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th style="width: 8%;">SL No</th>
                            <th style="width: 30%;">Test Name</th>
                            <th style="width: 10%;">Room No</th>
                            <th style="width: 10%;">Rate</th>
                            <th style="width: 10%;">Discount</th>
                            <th style="width: 10%;">MBBS</th>
                            <th style="width: 10%;">V.D</th>
                            <th style="width: 10%;">Emp</th>
                            <th style="width: 12%;">Corporate</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_rate = 0;
                        $total_mbbs = 0;
                        $total_vd = 0;
                        $total_emp = 0;
                        $total_corporate = 0;
                        $total_special_discount = 0;
                        foreach ($diagnostics as $obj) {
                            $total_rate += $obj->rate;
                            $total_mbbs += $obj->mbbs;
                            $total_vd += $obj->vd;
                            $total_emp += $obj->emp;
                            $total_corporate += $obj->corporate;
                            $total_special_discount += $obj->special_discount;
                        ?>
                            <tr>
                                <td style="padding: 0 2px;"><?php echo $count++; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->name; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->room_no; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->rate; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->special_discount; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->mbbs; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->vd; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->emp; ?></td>
                                <td style="padding: 0 2px;"><?php echo $obj->corporate; ?></td>
                            </tr>
                        <?php } ?>
                        <tr>
                            <td colspan="3" align="right"><b>Total</b></td>
                            <td><b><?php echo number_format($total_rate, 2); ?></b></td>
                            <td><b><?php echo number_format($total_special_discount, 2); ?></b></td>
                            <td><b><?php echo number_format($total_mbbs, 2); ?></b></td>
                            <td><b><?php echo number_format($total_vd, 2); ?></b></td>
                            <td><b><?php echo number_format($total_emp, 2); ?></b></td>
                            <td><b><?php echo number_format($total_corporate, 2); ?></b></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>