<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Payment_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_payment_list($invoice_type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $created_by) {
        $this->db->select('IP.*, P.patient_unique_id, P.name as patient, P.phone as p_phone, C.name as created_by');
        $this->db->from('payments AS IP');
        $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = IP.created_by', 'left');


        if ($invoice_type == 'all') {
            $this->db->select('D.name as doctor, AN.name as anesthetist, AS.name as assistant');
            $this->db->join('employees AS D', 'D.user_id = IP.commission_user_id', 'left');
            $this->db->join('anesthetists AS AN', 'AN.user_id = IP.commission_user_id', 'left');
            $this->db->join('assistants AS AS', 'AS.user_id = IP.commission_user_id', 'left');
        }

        if ($invoice_type == 'opd') {
            $this->db->select('OP.custom_invoice_id, OP.created_at as bill_date, D.name as doctor, R.name as reference');
            $this->db->join('opd_patients AS OP', 'OP.id = IP.invoice_id AND OP.invoice_type = IP.invoice_type', 'left');
            $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'ipd') {
            $this->db->select('IPI.custom_invoice_id, IPI.bill_date, D.name as doctor, R.name as reference');
            $this->db->join('ipd_invoices AS IPI', 'IPI.id = IP.invoice_id AND IPI.invoice_type = IP.invoice_type', 'left');
            $this->db->join('ipd_patients AS IPP', 'IPP.id = IPI.ipd_id', 'left');
            $this->db->join('employees AS D', 'D.user_id = IPP.doctor_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = IPI.commission_user_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'investigation') {
            $this->db->select('I.custom_invoice_id, I.bill_date, D.name as doctor, R.name as reference, R.phone as reference_phone,');
            $this->db->join('invoices AS I', 'I.id = IP.invoice_id AND I.invoice_type = IP.invoice_type', 'left');
            $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'surgeon') {
            $this->db->select('I.date as bill_date, D.name as doctor');
            $this->db->join('ipd_surgeons AS I', 'I.id = IP.invoice_id AND I.type = IP.invoice_type', 'left');
            $this->db->join('employees AS D', 'D.user_id = I.doctor_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'anesthesia') {
            $this->db->select('I.date as bill_date, D.name as doctor');
            $this->db->join('ipd_anesthesias AS I', 'I.id = IP.invoice_id AND I.type = IP.invoice_type', 'left');
            $this->db->join('anesthetists AS D', 'D.user_id = I.doctor_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'assistant') {
            $this->db->select('I.date as bill_date, D.name as doctor');
            $this->db->join('ipd_assistants AS I', 'I.id = IP.invoice_id AND I.type = IP.invoice_type', 'left');
            $this->db->join('assistants AS D', 'D.user_id = I.doctor_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($invoice_type == 'consultant') {
            $this->db->select('I.visit_date as bill_date, D.name as doctor');
            $this->db->join('ipd_consultant_visits AS I', 'I.id = IP.invoice_id AND I.type = IP.invoice_type', 'left');
            $this->db->join('employees AS D', 'D.user_id = I.doctor_id', 'left');
            $this->db->where('IP.invoice_type', $invoice_type);
        }
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(IP.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('IP.commission_user_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('IP.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('IP.created_by', $created_by);
        }
        $this->db->where('IP.payment_status', 'complete');
        $this->db->order_by('IP.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_single_reference($commission_user_id) {
        $this->db->select('P.*, E.name as commission, D.name as designation');
        $this->db->from('payments AS P');
        $this->db->join('employees AS E', 'E.user_id = P.commission_user_id', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($commission_user_id) {
            $this->db->where('P.commission_user_id', $commission_user_id);
        }
        return $this->db->get()->row();
    }
}
