<!DOCTYPE html>
<html>

<head>
	<title>Invoice Print</title>
	<style>
		body {
			font-family: "Time New Roman";
			font-size: 13px;
		}

		.page {
			width: 100%;
			margin: 0 auto;
		}

		.main_body {
			width: 100%;
			display: block;
		}

		.table {
			width: 100%;
			border-collapse: collapse;
		}

		.info_table {
			margin-top: 20px;
		}

		.content {
			margin-top: 20px;
		}

		.table_content thead th {
			padding: 0;
			vertical-align: middle;
			border: 1px solid #000;
			font-size: 12px;
			padding: 0 2px;
		}

		.table_content tbody td {
			padding: 0 2px;
			vertical-align: middle;
			border: 1px solid #000;
			font-size: 12px;
		}

		.total {
			margin-top: 20px;
		}

		.total_table tbody td {
			padding: 2px 2px;
			vertical-align: middle;
			border: 2px solid #000;
			font-size: 12px;
		}

		.footer {
			margin-top: 100px;
		}
	</style>
</head>

<body>
	<div class="page">
		<div class="main_body">
			<table class="table" style="text-align: center;">
				<tbody>
					<tr>
						<td>
							<h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
						</td>
					</tr>
					<tr>
						<td><b><?php echo $this->global_setting->address; ?></b></td>
					</tr>
					<tr>
						<td><b><?php echo $this->global_setting->email; ?></b></td>
					</tr>
					<tr>
						<td><b><?php echo $this->global_setting->phone; ?></b></td>
					</tr>
				</tbody>
			</table>

			<!-- Content Start-->
			<div class="content">
				<table class="table table_content">
					<thead>
						<tr>
							<th style="width: 10%;">Sl. No</th>
							<th style="width: 35%;">Medicine Name</th>
							<th style="width: 10%;">Batch No</th>
							<th style="width: 15%;">Expiry Date</th>
							<th style="width: 10%;">Quantity</th>
							<th style="width: 10%;">Rate</th>
							<th style="width: 10%;">Total</th>
						</tr>
					</thead>
					<tbody>
						<?php if (isset($details) & !empty($details)) { ?>
							<?php $count = 1; ?>
							<?php foreach ($details as $obj) { ?>
								<tr>
									<td class="text-center"><?php echo $count++; ?></td>
									<td class="text-left"><?php echo $obj->medicine_name; ?></td>
									<td class="text-right"><?php echo $obj->batch_no; ?></td>
									<td class="text-right"><?php echo $obj->expiry_date; ?></td>
									<td class="text-center"><?php echo $obj->quantity; ?></td>
									<td class="text-right"><?php echo $obj->rate; ?></td>
									<td class="text-right"><?php echo $obj->total_rate; ?></td>
								</tr>
							<?php } ?>
						<?php } ?>
					</tbody>
				</table>
			</div>
			<!-- Content End -->

			<!-- Footer -->
			<div class="footer">

			</div>
		</div>
	</div>
</body>

</html>