<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Type.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Type
 * @description     : Manage type.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Type extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Type_Model', 'type', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Type List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $keyword = $this->input->get('keyword');
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($keyword) {
            $config['base_url'] = site_url('leave/type/?keyword=' . $keyword);
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->type->get_type_list($config['per_page'], $offset, $keyword, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['types'] = $this->type->get_type_list($config['per_page'], $offset, $keyword, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['keyword'] = $keyword;


        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_type') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('type/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Type" user interface
     *                    and process to store "types" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        if ($_POST) {
            $this->_prepare_type_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_type_data();
                $insert_id = $this->type->insert('leave_types', $data);
                if ($insert_id) {
                    create_log('Has been created a leave type : ' . $data['type']);
                    success($this->lang->line('insert_success'));
                    redirect('leave/type');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('leave/type/add');
                }
            } else {
                $this->data = $_POST;
            }
        }
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->global_setting->brand_title);
        $this->layout->view('type/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Type" user interface
     *                    with populate "Type" value
     *                    and process to update "types" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);
        if ($_POST) {
            $this->_prepare_type_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_type_data();
                $updated = $this->type->update('leave_types', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a leave type : ' . $data['type']);
                    success($this->lang->line('update_success'));
                    redirect('leave/type');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('leave/type/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['type'] = $this->type->get_single('leave_types', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['type'] = $this->type->get_single('leave_types', array('id' => $id));
                if (!$this->data['type']) {
                    redirect('leave/type');
                }
            }
        }
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->global_setting->brand_title);
        $this->layout->view('type/edit', $this->data);
    }

    /*     * ***************Function get_single_type**********************************
     * @type            : Function
     * @function name   : get_single_type
     * @description     : "Load single type information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_type() {
        $id = $this->input->post('id');
        $this->data['type'] = $this->type->get_single_type($id);
        echo $this->load->view('leave/type/view', $this->data);
    }

    /*****************Function _prepare_type_validation**********************************
     * @type            : Function
     * @function name   : _prepare_type_validation
     * @description     : Process "Type" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_type_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('type', $this->lang->line('type'), 'trim|required|callback_type');
        $this->form_validation->set_rules('total_leave', $this->lang->line('total') . ' ' . $this->lang->line('leave'), 'trim|required');
    }

    /*****************Function type**********************************
     * @type            : Function
     * @function name   : type
     * @description     : Unique check for "Type Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function type() {
        if ($this->input->post('id') == '') {
            $type = $this->type->duplicate_check($this->input->post('type'));
            if ($type) {
                $this->form_validation->set_message('type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $type = $this->type->duplicate_check($this->input->post('type'), $this->input->post('id'));
            if ($type) {
                $this->form_validation->set_message('type', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function _get_posted_type_data**********************************
     * @type            : Function
     * @function name   : _get_posted_type_data
     * @description     : Prepare "Type" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_type_data() {

        $items = array();
        $items[] = 'type';
        $items[] = 'total_leave';
        $items[] = 'remark';
        $data = elements($items, $_POST);

        $data['status'] = $this->input->post('status') ?? 0;
        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        return $data;
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Type" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('leave/type');
        }

        $type = $this->type->get_single('leave_types', array('id' => $id));
        if (isset($type) && $id > 0) {
            $this->db->trans_start();
            create_log('Has been deleted a leave type : ' . $type->type);
            $this->type->delete('leave_types', array('id' => $id));
            $this->db->trans_complete();
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
