<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $pulsebp->patient_name; ?></td>
                    <td><?php echo $this->lang->line('patient_id'); ?></td>
                    <td><?php echo $pulsebp->patient_unique_id; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('doctor'); ?></td>
                    <td><?php echo $pulsebp->doctor; ?></td>
                    <td><?php echo $this->lang->line('nurse'); ?></td>
                    <td><?php echo $pulsebp->nurse; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($pulsebp->date)); ?></td>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td><?php echo $pulsebp->note; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('bp'); ?></td>
                    <td><?php echo $pulsebp->bp; ?></td>
                    <td><?php echo $this->lang->line('pulse'); ?></td>
                    <td><?php echo $pulsebp->pulse; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('temp'); ?></td>
                    <td><?php echo $pulsebp->temperature; ?></td>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($pulsebp->pulsebp_status == 'complete') { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                        <?php } elseif ($pulsebp->pulsebp_status == 'rejected') { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                        <?php } elseif ($pulsebp->pulsebp_status == 'pending') { ?>
                            <span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                        <?php } ?>
                    </td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $pulsebp->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($pulsebp->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $pulsebp->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $pulsebp->modified_by ? date('d F, Y h:i A', strtotime($pulsebp->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>