<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Followup.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Followup
 * @description     : Manage IPD Followup Chart.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Followup extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Followup_Model', 'followup', true);
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    public function index($ipd_id) {

        check_permission(VIEW);

        $this->data['patient'] = $this->ipd->get_single_ipd_patient($ipd_id);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('follow_up') . ' ' . $this->lang->line('chart') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('follow-up/index', $this->data);
    }
}
