<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Appointment_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_doctor_list()
    {
        $this->db->select('C.*, E.*');
        $this->db->from('doctor_charges AS C');
        $this->db->join('users AS U', 'U.id = C.doctor_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        return $this->db->get()->result();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_appointment_list($limit, $offset, $keyword = null, $date = null, $doctor_id = null, $count = 0)
    {
        $this->db->select('A.*, E.name as doctor, R.name as reference, C.name as created_by');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.doctor_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = A.created_by', 'left');
        $this->db->join('employees AS R', 'R.user_id = A.reference_id', 'left');
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('A.phone', $keyword, 'both');
            $this->db->or_like('A.name', $keyword, 'both');
            $this->db->or_like('A.address', $keyword, 'both');
            $this->db->or_like('A.appointment_no', $keyword, 'both');
            $this->db->or_like('E.name', $keyword, 'both');
            $this->db->or_like('R.name', $keyword, 'both');
            $this->db->group_end();
        }
        if ($date) {
            $this->db->where('A.date', $date);
        
        } else {
            $this->db->where('DATE(A.created_at)', date('Y-m-d'));
        }
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        $this->db->order_by('A.created_at', 'DESC');
        if ($this->session->userdata('role_id') === MARKETING) {
            $this->db->where('A.created_by', $this->session->userdata('user_id'));
        }
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_patient_list($limit, $offset, $search, $count)
    {
        $this->db->select('A.*,');
        $this->db->from('patients AS A');
        if ($search) {
            $this->db->like('patient_unique_id', $search);
            $this->db->or_like('phone', $search);
            $this->db->or_like('name', $search, 'both');
            $this->db->or_like('address', $search);
        }
        $this->db->order_by('A.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_reference_phone($phone, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('phone', $phone);
        return $this->db->get('employees')->num_rows();
    }

    function duplicate_check($name, $phone, $id = null)
    {
        if ($id) {
            $this->db->where_not_in('user_id', $id);
        }
        $this->db->where('name', $name);
        $this->db->where('phone', $phone);
        return $this->db->get('patients')->num_rows();
    }

    public function get_single_appointment($id)
    {
        $this->db->select('A.*, E.name as doctor, R.name as reference, C.name as created_by, U.name as modified_by');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.doctor_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = A.reference_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = A.created_by', 'left');
        $this->db->join('employees AS U', 'U.user_id = A.modified_by', 'left');
        $this->db->where('A.id', $id);
        return $this->db->get()->row();
    }


    public function get_patient_details($user_id)
    {
        $this->db->select('P.*');
        $this->db->from('patients AS P');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->where('P.user_id', $user_id);
        return $this->db->get()->row();
    }

    public function get_doctor_charges($doctor_id)
    {
        $this->db->select('DC.*');
        $this->db->from('doctor_charges AS DC');
        $this->db->where('DC.doctor_id', $doctor_id);
        return $this->db->get()->row();
    }

    public function get_patient_visit_bill($patient_id, $opt_id, $appointment_id)
    {
        $this->db->select('P.*, OP.*, E.name as doctor, E.specialist, D.name as designation, PC.name as create_by, AP.appointment_no');
        $this->db->from('patients AS P');
        $this->db->join('opd_patients AS OP', 'OP.patient_id = P.user_id', 'left');
        $this->db->join('appointments AS AP', 'AP.patient_id = P.user_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = OP.doctor_id', 'left');
        $this->db->join('employees AS PC', 'PC.user_id = OP.created_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        $this->db->join('users AS U', 'U.id = P.user_id', 'left');
        $this->db->join('roles AS R', 'R.id = U.role_id', 'left');
        $this->db->where('P.user_id', $patient_id);
        $this->db->where('OP.id', $opt_id);
        $this->db->where('AP.id', $appointment_id);
        return $this->db->get()->row();
    }
}
