<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('frontend'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontend', 'frontend')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-desktop font-30 mr-10"></i>
                            <?php echo $this->lang->line('manage'); ?> <?php echo $this->lang->line('support'); ?>
                        </h6>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/support'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="support"><?php echo $this->lang->line('24_7_support'); ?></label>
                            <textarea rows="5" class="form-control" name="support" id="support" placeholder="<?php echo $this->lang->line('24_7_support'); ?>"><?php echo isset($support->support) ?  $support->support : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_support"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('24_7_support'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_support" id="bn_support" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('24_7_support'); ?>"><?php echo isset($support->bn_support) ?  $support->bn_support : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="expert_doctor"><?php echo $this->lang->line('expert_doctor'); ?></label>
                            <textarea rows="5" class="form-control" name="expert_doctor" id="expert_doctor" placeholder="<?php echo $this->lang->line('expert_doctor'); ?>"><?php echo isset($support->expert_doctor) ?  $support->expert_doctor : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_expert_doctor"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('expert_doctor'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_expert_doctor" id="bn_expert_doctor" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('expert_doctor'); ?>"><?php echo isset($support->bn_expert_doctor) ?  $support->bn_expert_doctor : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="online_payment"><?php echo $this->lang->line('online_payment'); ?></label>
                            <textarea rows="5" class="form-control" name="online_payment" id="online_payment" placeholder="<?php echo $this->lang->line('online_payment'); ?>"><?php echo isset($support->online_payment) ?  $support->online_payment : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_online_payment"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('online_payment'); ?></label>
                            <textarea rows="5" class="form-control" name="bn_online_payment" id="bn_online_payment" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('online_payment'); ?>"><?php echo isset($support->bn_online_payment) ?  $support->bn_online_payment : ''; ?></textarea>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo isset($support) & !empty($support) ? $this->lang->line('update') : $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->