<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('service'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_service'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('frontend/left-side'); ?>
        <!-- col-lg-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'frontend', 'service')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-server font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('service'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontend', 'service')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend/service'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('service'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/service/edit/' . $service->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control" name="type" id="type">
                                <option value="service" <?php echo isset($service) && $service->type == 'service' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('service'); ?></option>
                                <option value="why_choose_us" <?php echo isset($service) && $service->type == 'why_choose_us' ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('why_choose_us'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="title"><?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="title" id="title" value="<?php echo isset($service->title) ?  $service->title : ''; ?>" placeholder="<?php echo $this->lang->line('title'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="title" class="form-text text-muted">
                                <?php echo form_error('title'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="bn_title"><?php echo $this->lang->line('bn_title'); ?></label>
                            <input type="text" class="form-control" name="bn_title" id="bn_title" value="<?php echo isset($service->bn_title) ?  $service->bn_title : ''; ?>" placeholder="<?php echo $this->lang->line('bn_title'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bn_title" class="form-text text-muted">
                                <?php echo form_error('bn_title'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="icon"><?php echo $this->lang->line('icon'); ?></label>
                            <input type="text" class="form-control" name="icon" id="icon" value="<?php echo isset($service->icon) ?  $service->icon : ''; ?>" placeholder="<?php echo $this->lang->line('icon'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($service->sort_by) ?  $service->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-7 mb-10">
                            <label for="image"><?php echo $this->lang->line('image'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="image">
                                        <input type="hidden" name="prev_image" value="<?php echo $service->image; ?>">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="image" class="form-text text-muted">
                                <?php echo form_error('image'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_home" id="is_view_on_home" value="1" <?php echo $service->is_view_on_home ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_view_on_home"><?php echo $this->lang->line('is_view_on_home'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mt-10">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_on_web" id="is_view_on_web" value="1" <?php echo $service->is_view_on_web ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="is_view_on_web"><?php echo $this->lang->line('is_view_on_web'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('description'); ?></span>
                                </div>
                                <textarea class="form-control" name="description" id="description" aria-label="<?php echo $this->lang->line('description'); ?>"><?php echo isset($service->description) ?  $service->description : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('bn_description'); ?></span>
                                </div>
                                <textarea class="form-control" name="bn_description" id="bn_description" aria-label="<?php echo $this->lang->line('bn_description'); ?>"><?php echo isset($service->bn_description) ?  $service->bn_description : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $service->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend/service'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->