<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('frontend'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_frontend'); ?>
        </h4>
    </div>
    <!-- /Title -->
    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'frontend', 'frontend')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-desktop font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('page'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'frontend', 'frontend')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('frontend'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('page'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('frontend/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-6 mb-10">
                            <label for="title"><?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="title" id="title" value="<?php echo isset($title) ?  $title : ''; ?>" placeholder="<?php echo $this->lang->line('title'); ?>" required>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="title" class="form-text text-muted">
                                <?php echo form_error('title'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="bn_title"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="bn_title" id="bn_title" value="<?php echo isset($bn_title) ?  $bn_title : ''; ?>" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('title'); ?>">
                        </div>
                        <div class="col-md-1 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="sidebar" id="sidebar" value="1">
                                <label class="custom-control-label" for="sidebar"><?php echo $this->lang->line('sidebar'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="image"><?php echo $this->lang->line('image'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="image">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="image_view" id="image_view" value="1" checked>
                                <label class="custom-control-label" for="image_view"><?php echo $this->lang->line('image'); ?> <?php echo $this->lang->line('view'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="image_full_width" id="image_full_width" value="1">
                                <label class="custom-control-label" for="image_full_width"><?php echo $this->lang->line('image'); ?> <?php echo $this->lang->line('full_width'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="attachment"><?php echo $this->lang->line('attachment'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="attachment">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-2 mt-40">
                            <div class="custom-control custom-checkbox checkbox-primary">
                                <input type="checkbox" class="custom-control-input" name="is_view_pdf" id="is_view_pdf" value="1">
                                <label class="custom-control-label" for="is_view_pdf"><?php echo $this->lang->line('is_view_pdf'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="description"><?php echo $this->lang->line('description'); ?></label>
                            <textarea class="form-control" name="description" id="description" placeholder="<?php echo $this->lang->line('description'); ?>"><?php echo isset($description) ?  $description : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mt-10 mb-10">
                            <label for="bn_description"><?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('description'); ?></label>
                            <textarea class="form-control" name="bn_description" id="bn_description" placeholder="<?php echo $this->lang->line('bangla'); ?> <?php echo $this->lang->line('description'); ?>"><?php echo isset($bn_description) ?  $bn_description : ''; ?></textarea>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="meta_title"><?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('title'); ?></label>
                            <input type="text" class="form-control" name="meta_title" id="meta_title" value="<?php echo isset($meta_title) ?  $meta_title : ''; ?>" placeholder="<?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('title'); ?>">
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="meta_keyword"><?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('keyword'); ?></label>
                            <input type="text" class="form-control" name="meta_keyword" id="meta_keyword" value="<?php echo isset($meta_keyword) ?  $meta_keyword : ''; ?>" placeholder="<?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('keyword'); ?>">
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('description'); ?></span>
                                </div>
                                <textarea class="form-control" name="meta_description" id="meta_description" aria-label="<?php echo $this->lang->line('meta'); ?> <?php echo $this->lang->line('description'); ?>"><?php echo isset($meta_description) ?  $meta_description : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('frontend'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script src="<?php echo VENDOR_URL; ?>tinymce-5.0/tinymce.min.js"></script>
<script>
    tinymce.init({
        forced_root_block: "",
        selector: '#description, #bn_description',
        branding: false,
        min_height: 300,
        plugins: 'link image table code preview fullscreen lists media',
        toolbar: [{
                name: 'history',
                items: ['undo', 'redo']
            },
            {
                name: 'styles',
                items: ['styleselect', 'bullist', 'numlist']
            },
            {
                name: 'formatting',
                items: ['bold', 'italic', 'underline', 'backcolor', 'forecolor']
            },
            {
                name: 'alignment',
                items: ['alignleft', 'aligncenter', 'alignright', 'alignjustify']
            },
            {
                name: 'indentation',
                items: ['outdent', 'indent']
            },
            {
                name: 'insert',
                items: ['media', 'image']
            }
        ]
    })
</script>