<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Slider_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_slider_list($limit, $offset, $keyword, $count) {
        $this->db->select('S.*');
        $this->db->from('sliders AS S');
        if ($keyword) {
            $this->db->like('S.title', $keyword, 'both');
            $this->db->or_like('S.note', $keyword, 'both');
        }
        $this->db->order_by('S.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
