<div class="table-wrap">
	<div class="table-responsive">
		<table class="table table-sm">
			<tbody>
				<tr>
					<td class="w-40 border-0 p-1" style="vertical-align: top;">
						<table class="table table-sm table-bordered text-white">
							<thead class="bg-info">
								<tr>
									<th colspan="2" class="text-center text-white">Patient Info:</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>Patient ID</td>
									<td><?php echo $patient->patient_unique_id; ?></td>
								</tr>
								<tr>
									<td>Patient Name</td>
									<td><?php echo $patient->patient; ?></td>
								</tr>
								<tr>
									<td>Patient Age</td>
									<td><?php echo get_age($patient->dob); ?></td>
								</tr>
								<tr>
									<td>Gender</td>
									<td><?php echo $this->lang->line($patient->gender); ?></td>
								</tr>
								<tr>
									<td>Address</td>
									<td><?php echo $patient->address; ?></td>
								</tr>
								<tr>
									<td>Patient Category</td>
									<td><?php echo $patient->followup_category; ?></td>
								</tr>
								<tr>
									<td>Last Visited Doctor</td>
									<td><?php echo $doctor->doctor ?? ''; ?></td>
								</tr>
								<tr>
									<td>Last Visited Date</td>
									<td><?php echo isset($doctor->appointment_date) && $doctor->appointment_date != null ? date('d M, Y', strtotime($doctor->appointment_date)) : ''; ?></td>
								</tr>
								<tr>
									<td>Followup Date</td>
									<td><?php echo date('d M, Y', strtotime($patient->followup_date)); ?></td>
								</tr>
								
								<tr>
									<td>Remark</td>
									<td><?php echo $patient->note; ?></td>
								</tr>
							</tbody>
						</table>
					</td>
					<td class="w-60 border-0 p-1" style="vertical-align: top;">
						<table class="table table-sm table-bordered text-white">
							<thead class="bg-info">
								<tr>
									<th colspan="5" class="text-center text-white">Last 7 Submitted Followup</th>
								</tr>
								<tr>
									<th>Followup Date</th>
									<th>Followup Detail’s</th>
									<th>Status</th>
									<th>Created Date</th>
									<th>Created By</th>
								</tr>
							</thead>
							<tbody>
								<?php if (isset($followup_histories) && !empty($followup_histories)) { ?>
									<?php foreach ($followup_histories as $obj) { ?>
										<tr>
											<td><?php echo date('d M, Y', strtotime($obj->followup_date)); ?></td>
											<td><?php echo $obj->note; ?></td>
											<td><?php echo $obj->status ? '<span class="badge badge-success">' .  $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' .  $this->lang->line('in_active') . '</span>'; ?></td>
											<td><?php echo date('d M, Y', strtotime($obj->create_date)); ?></td>
											<td><?php echo $obj->created_by; ?></td>
										</tr>
									<?php } ?>
								<?php } else { ?>
									<tr class="text-center">
										<td colspan="5"><?php echo $this->lang->line('no_data_found'); ?></td>
									</tr>
								<?php } ?>
							</tbody>
						</table>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>