<!--Add Appointment Modal-->
<div class="modal fade addModalCenter" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title mr-30"><?php echo $this->lang->line('add') . " " . $this->lang->line('followup'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <?php echo form_open_multipart(site_url('followup/patient/followup'), array('name' => 'addFollowupForm', 'id' => 'addFollowupForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-3 mb-10">
                        <label for="followup_status"><?php echo $this->lang->line('status'); ?> <span class="required">*</span></label>
                        <select class="form-control custom-select" name="status" id="followup_status">
                            <option value="1"><?php echo $this->lang->line('active'); ?></option>
                            <option value="0"><?php echo $this->lang->line('in_active'); ?></option>
                        </select>
                    </div>
                    <div class="col-md-12 mb-10">
                        <label for="followup_note"><?php echo $this->lang->line('remark'); ?></label>
                        <textarea class="form-control" name="note" id="followup_note" aria-label="<?php echo $this->lang->line('note'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="followup_id" name="followup_id">
                <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    function get_add_modal(id) {
        $('#followup_id').val(id);
    }
    $(document).ready(function(e) {
        $("#addFollowupForm").on('submit', (function(e) {
            e.preventDefault();
            $('button[type=submit]').attr('disabled', true);
            if ($("#followup_status").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('followup/patient/followup') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            window.location.href = "<?php echo site_url('followup/patient'); ?>";
                        }
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>