<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Template.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Template
 * @description     : Manage template.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Template_old extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Template_Old_Model', 'template_old', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Template List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = $this->input->get('search');

        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('diagnostic/template_old/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->template_old->get_template_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['templates'] = $this->template_old->get_template_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

        $this->data['search'] = $search;
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('diagnostic') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('template_old/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Template" user interface
     *                    and process to store "templates" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        if ($_POST) {
            $this->_prepare_template_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_template_data();
                $insert_id = $this->template_old->insert('diagnostic_templates', $data);
                if ($insert_id) {
                    create_log('Has been created a Template : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('diagnostic/template_old');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('diagnostic/template_old/add');
                }
            } else {
                $this->data = $_POST;
            }
        }
        $this->data['departments'] = $this->template_old->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('template_old/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Template" user interface
     *                    with populate "Template" value
     *                    and process to update "templates" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {
        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_template_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_template_data();
                $updated = $this->template_old->update('diagnostic_templates', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Template : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('diagnostic/template_old');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('diagnostic/template_old/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['template'] = $this->template_old->get_single('diagnostic_templates', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['template'] = $this->template_old->get_single('diagnostic_templates', array('id' => $id));
                if (!$this->data['template']) {
                    redirect('diagnostic/template_old');
                }
            }
        }
        $this->data['departments'] = $this->template_old->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['groups'] = $this->template_old->get_list('diagnostic_groups', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['tests'] = $this->template_old->get_list('diagnostic_tests', array('status' => 1, 'department_id' => $this->data['template']->department_id), '', '', '', 'sort_by', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('template') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('template_old/edit', $this->data);
    }

    /*     * ***************Function get_single_template**********************************
     * @type            : Function
     * @function name   : get_single_template
     * @description     : "Load single template information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_template() {
        $id = $this->input->post('id');
        $this->data['template'] = $this->template_old->get_single_template($id);
        echo $this->load->view('diagnostic/template_old/view', $this->data);
    }

    /*****************Function _prepare_template_validation**********************************
     * @type            : Function
     * @function name   : _prepare_template_validation
     * @description     : Process "Template" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_template_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('department_id', $this->lang->line('department') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('test_id', $this->lang->line('test') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('template', $this->lang->line('template'), 'trim|required');
    }

    /*****************Function _get_posted_template_data**********************************
     * @type            : Function
     * @function name   : _get_posted_template_data
     * @description     : Prepare "Template" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_template_data() {

        $items = array();
        $items[] = 'department_id';
        $items[] = 'group_id';
        $items[] = 'test_id';
        $items[] = 'name';
        $items[] = 'template';
        $items[] = 'status';

        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }
        return $data;
    }

    /*     * ***************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Template" data from database
     *                     and unlink template photo and Resume from server
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('diagnostic/template_old');
        }

        $template = $this->template_old->get_single('diagnostic_templates', array('id' => $id));
        if (!empty($template)) {
            // delete template data
            $this->template_old->delete('diagnostic_templates', array('id' => $id));
            create_log('Has been deleted a Template : ' . $template->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('diagnostic/template_old');
    }
}
