<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Laboratorist.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Laboratorist
 * @description     : Manage laboratorist.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Laboratorist extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Laboratorist_Model', 'laboratorist', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Laboratorist List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = $this->input->get('search');

        $config = array();
        $config = get_pagination(5);
        if ($search) {
            $config['base_url'] = site_url('diagnostic/laboratorist/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->laboratorist->get_laboratorist_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['laboratorists'] = $this->laboratorist->get_laboratorist_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

        $this->data['search'] = $search;
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('diagnostic') . ' ' . $this->lang->line('laboratorist') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('laboratorist/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Laboratorist" user interface
     *                    and process to store "laboratorists" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);
        if ($_POST) {
            $this->_prepare_laboratorist_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_laboratorist_data();
                $insert_id = $this->laboratorist->insert('diagnostic_laboratorists', $data);
                if ($insert_id) {
                    create_log('Has been created a Laboratorist : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('diagnostic/laboratorist');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('diagnostic/laboratorist/add');
                }
            } else {
                $this->data = $_POST;
            }
        }
        $this->data['departments'] = $this->laboratorist->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('laboratorist') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('laboratorist/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Laboratorist" user interface
     *                    with populate "Laboratorist" value
     *                    and process to update "laboratorists" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {
        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_laboratorist_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_laboratorist_data();
                $updated = $this->laboratorist->update('diagnostic_laboratorists', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Laboratorist : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('diagnostic/laboratorist');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('diagnostic/laboratorist/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['laboratorist'] = $this->laboratorist->get_single('diagnostic_laboratorists', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['laboratorist'] = $this->laboratorist->get_single('diagnostic_laboratorists', array('id' => $id));
                if (!$this->data['laboratorist']) {
                    redirect('diagnostic/laboratorist');
                }
            }
        }
        $this->data['departments'] = $this->laboratorist->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('laboratorist') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('laboratorist/edit', $this->data);
    }


    /*****************Function _prepare_laboratorist_validation**********************************
     * @type            : Function
     * @function name   : _prepare_laboratorist_validation
     * @description     : Process "Laboratorist" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_laboratorist_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('department_id', $this->lang->line('department') . ' ' . $this->lang->line('name'), 'trim|required');
        $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');
    }

    /*****************Function _get_posted_laboratorist_data**********************************
     * @type            : Function
     * @function name   : _get_posted_laboratorist_data
     * @description     : Prepare "Laboratorist" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_laboratorist_data() {

        $items = array();
        $items[] = 'department_id';
        $items[] = 'name';
        $items[] = 'sort_by';
        $items[] = 'status';

        $data = elements($items, $_POST);

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }
        return $data;
    }

    /*     * ***************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Laboratorist" data from database
     *                     and unlink laboratorist photo and Resume from server
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */

    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('diagnostic/laboratorist');
        }

        $laboratorist = $this->laboratorist->get_single('diagnostic_laboratorists', array('id' => $id));
        if (!empty($laboratorist)) {
            // delete laboratorist data
            $this->laboratorist->delete('diagnostic_laboratorists', array('id' => $id));
            create_log('Has been deleted a Laboratorist : ' . $laboratorist->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect('diagnostic/laboratorist');
    }
}
