<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Event.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Event
 * @description     : Manage event.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Event extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Event_Model', 'event', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Event List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $role_id = $this->input->get('role_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('announcement/event/?keyword=' . $keyword . '&date=' . $date . '&role_id=' . $role_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }
            $config['total_rows'] = $this->event->get_event_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $role_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['events'] = $this->event->get_event_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $role_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['role_id'] = $role_id;
            $this->data['created_by'] = $created_by;
        } else {
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->event->get_event_list($config['per_page'], $offset, null, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['events'] = $this->event->get_event_list($config['per_page'], $offset, null, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['roles'] = $this->event->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['employees'] = $this->event->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_event') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('event/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Event" user interface
     *                    and process to store "events" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->_prepare_event_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_event_data();
                $insert_id = $this->event->insert('events', $data);
                if ($insert_id) {
                    create_log('Has been created a Event : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('announcement/event');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('announcement/event/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['roles'] = $this->event->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('event') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('event/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Event" user interface
     *                    with populate "Event" value
     *                    and process to update "events" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_event_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_event_data();
                $updated = $this->event->update('events', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Event : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('announcement/event');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('announcement/event/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['event'] = $this->event->get_single('events', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['event'] = $this->event->get_single('events', array('id' => $id));
                if (!$this->data['event']) {
                    redirect('announcement/event');
                }
            }
        }

        $this->data['roles'] = $this->event->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('event') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('event/edit', $this->data);
    }


    /*     * ***************Function get_single_event**********************************
     * @type            : Function
     * @function name   : get_single_event
     * @description     : "Load single event information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_event() {
        $id = $this->input->post('id');
        $this->data['event'] = $this->event->get_single_event($id);
        echo $this->load->view('event/view', $this->data);
    }

    /*****************Function _prepare_event_validation**********************************
     * @type            : Function
     * @function name   : _prepare_event_validation
     * @description     : Process "Event" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_event_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
        $this->form_validation->set_rules('event_from', $this->lang->line('event_from'), 'trim|required');
        $this->form_validation->set_rules('event_to', $this->lang->line('event_to'), 'trim|required');
    }

    /*****************Function _get_posted_event_data**********************************
     * @type            : Function
     * @function name   : _get_posted_event_data
     * @description     : Prepare "Event" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_event_data() {

        $items = array();
        $items[] = 'role_id';
        $items[] = 'title';
        $items[] = 'event_place';
        $items[] = 'description';
        $items[] = 'is_view_on_web';
        $items[] = 'status';
        $data = elements($items, $_POST);

        $data['event_from'] = $this->input->post('event_from') ? date('Y-m-d H:i:s', strtotime($this->input->post('event_from'))) : date('Y-m-d H:i:s');
        $data['event_to'] = $this->input->post('event_to') ? date('Y-m-d H:i:s', strtotime($this->input->post('event_to'))) : date('Y-m-d H:i:s');

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        if ($_FILES['image']['name']) {
            $data['image'] = $this->_upload_image();
        }

        return $data;
    }

    /*     * ***************Function _upload_image**********************************
     * @type            : Function
     * @function name   : _upload_image
     * @description     : Process to upload event image into server
     *                     and return image file name
     * @param           : null
     * @return          : $return_image string value
     * ********************************************************** */

    private function _upload_image() {

        $prev_image = $this->input->post('prev_image');
        $image = $_FILES['image']['name'];
        $image_type = $_FILES['image']['type'];
        $return_image = '';

        if ($image != "") {
            if (
                $image_type == 'image/jpeg' || $image_type == 'image/pjpeg' ||
                $image_type == 'image/jpg' || $image_type == 'image/png' ||
                $image_type == 'image/x-png' || $image_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/event/';

                $file_type = explode(".", $image);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $image_path = 'event-image-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['image']['tmp_name'], $destination . $image_path);

                // need to unlink previous image
                if ($prev_image != "") {
                    if (file_exists($destination . $prev_image)) {
                        @unlink($destination . $prev_image);
                    }
                }

                $return_image = $image_path;
            }
        } else {
            $return_image = $prev_image;
        }

        return $return_image;
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Event" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('announcement/event');
        }

        $event = $this->event->get_single('events', array('id' => $id));

        if ($this->event->delete('events', array('id' => $id))) {
            // delete image
            $destination = 'assets/uploads/';
            if (file_exists($destination . '/event/' . $event->image)) {
                @unlink($destination . '/event/' . $event->image);
            }
            create_log('Has been deleted a Event : ' . $event->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
