<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * ******************Theme.php*******************************
	 * @product name    : Hospital Management System
	 * @type            : Class
	 * @class name      : Theme
	 * @description     : This class used to manage color theme functionality
	 *                    of the application.
	 * @author          : South Bangla IT Zone Team
	 * @url             : http://hms.sbitzone.com
	 * @support         : rabibd.it@gmail.com
	 * @copyright       : South Bangla IT Zone Team
	 * ********************************************************** */

class Theme extends My_Controller {

    public function __construct() {

        parent::__construct();
        $this->load->model('Theme_Model', 'theme', true);
    }

    /*     * **************Function index**********************************
		 * @type            : Function
		 * @function name   : index
		 * @description     : this function used to load all default color theme
		 * @param           : null;
		 * @return          : null
		 * ********************************************************** */

    public function index() {

        check_permission(VIEW);

        $this->layout->title($this->lang->line('theme') . ' | ' . TITLE);
        $this->layout->view('theme', $this->data);
    }

    /*     * **************Function activate**********************************
		 * @type            : Function
		 * @function name   : activate
		 * @description     : this function used to activate user selected theme
		 *                    after successfully activated color theme it's
		 *                    redirected to all default color theme
		 * @param           : $id integer value;
		 * @return          : null
		 * ********************************************************** */

    public function activate() {
        check_permission(EDIT);
    }
}
