<!DOCTYPE html>
<html>

<head>
    <title>Schedule</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content {
            border-collapse: collapse;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 14px;
            font-weight: bold;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #222;
            font-size: 14px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h1 align="center" style="margin-bottom: 0;">
                <?php if ($type == 1) { ?>
                    ডাক্তারের সময়সূচী
                <?php } else { ?>
                    Doctor's Schedule
                <?php } ?>
            </h1>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <?php if ($type == 1) { ?>
                                    <?php if ($doctor_id) { ?>
                                        ডাক্তারঃ <?php echo $doctor->bn_name; ?>, <?php echo $doctor->specialist; ?>
                                    <?php } else { ?>
                                        ডাক্তারঃ সব
                                    <?php }  ?>
                                <?php } else { ?>
                                    <?php if ($doctor_id) { ?>
                                        Doctor: <?php echo $doctor->name; ?>, <?php echo $doctor->specialist; ?>
                                    <?php } else { ?>
                                        Doctor: All
                                    <?php }  ?>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <?php if ($type == 1) { ?>
                                    প্রিন্ট টাইমঃ <?php echo en2bn(date('d/m/Y h:ia')); ?>
                                <?php } else { ?>
                                    Print Time: <?php echo date('d/m/Y h:ia'); ?>
                                <?php } ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <?php if ($type == 1) { ?>
                            <tr>
                                <th width="10%">ক্রমিক নং</th>
                                <th width="40%">ডাক্তার নাম</th>
                                <th width="10%">সপ্তাহের নাম</th>
                                <th width="20%">সময়</th>
                                <th width="10%">মন্তব্য</th>
                                <th width="10%">স্বাক্ষর</th>
                            </tr>
                        <?php } else { ?>
                            <tr>
                                <th width="10%">#SL No</th>
                                <th width="40%">Doctor's Name</th>
                                <th width="10%">Week</th>
                                <th width="20%">Time</th>
                                <th width="10%">Remark</th>
                                <th width="10%">Signature</th>
                            </tr>
                        <?php } ?>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        if (isset($schedules) && !empty($schedules)) { ?>
                            <?php foreach ($schedules as $obj) { ?>
                                <tr>
                                    <td><?php echo $type == 1 ? en2bn($count++) : $count++; ?></td>
                                    <td><?php echo $type == '1' ? $obj->doctor_bn : $obj->doctor; ?></td>
                                    <td><?php echo $obj->day; ?></td>
                                    <td>
                                        <?php echo isset($obj->start_time) && !empty($obj->start_time) ? date('h:ia', strtotime($obj->start_time)) : ''; ?>
                                        <?php echo isset($obj->end_time) && !empty($obj->end_time) ? ' - ' . date('h:ia', strtotime($obj->end_time)) : ''; ?>
                                    </td>
                                    <td><?php echo $obj->note; ?></td>
                                    <td></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>