<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Marketing_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }
    public function get_doctor_list()
    {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }
    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_marketing_list($type, $keyword, $form_date, $to_date, $doctor_id, $reference_id, $commission, $created_by)
    {
        if ($type == 'test') {
            $this->db->select('I.id as invoice_id, I.appointment_id, I.bill_date, I.net_payable, I.commission_amount, I.payable_commission, I.discount, A.appointment_no, A.date as appointment_date, P.patient_unique_id, P.name as patient_name, P.phone, D.name as doctor, R.name as reference');
            $this->db->from('invoices AS I');
            $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
            $this->db->join('appointments AS A', 'A.id = I.appointment_id', 'left');
            $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
            $this->db->where('I.payment_status', 'complete');
            $this->db->where('I.paid_status', 'paid');
            if ($keyword) {
                $this->db->like('P.patient_unique_id', $keyword);
                $this->db->or_like('P.phone', $keyword, 'both');
                $this->db->or_like('P.name', $keyword, 'both');
            }
            if ($form_date && $to_date) {
                $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
            }
            if ($doctor_id) {
                $this->db->where('I.ref_dr_id', $doctor_id);
            }
            if ($reference_id) {
                $this->db->where('I.commission_user_id', $reference_id);
            }
            if ($commission == 1) {
                $this->db->where('I.commission_user_id >', 0);
            }
            if ($commission == 2) {
                $this->db->group_start();
                $this->db->where('I.commission_user_id', 0);
                $this->db->or_where('I.commission_user_id', NULL);
                $this->db->or_where('I.commission_user_id', '');
                $this->db->group_end();
            }
            if ($created_by) {
                $this->db->where('I.marketing_id', $created_by);
            }
            $this->db->order_by('I.bill_date', 'ASC');
        } elseif ($type == 'opd') {
            $this->db->select('A.appointment_no, OP.doctor_charge, A.date as appointment_date, OP.appointment_date as bill_date, OP.patient_id, OP.appointment_id, P.patient_unique_id, P.name as patient_name, P.phone, D.name as doctor, R.name as reference');
            $this->db->from('opd_patients AS OP');
            $this->db->join('patients AS P', 'P.user_id = OP.patient_id', 'left');
            $this->db->join('appointments AS A', 'A.id = OP.appointment_id', 'left');
            $this->db->join('employees AS D', 'D.user_id = OP.doctor_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = OP.reference_id', 'left');

            if ($keyword) {
                $this->db->like('P.patient_unique_id', $keyword);
                $this->db->or_like('P.phone', $keyword, 'both');
                $this->db->or_like('P.name', $keyword, 'both');
            }
            if ($form_date && $to_date) {
                $this->db->where("DATE(OP.appointment_date) BETWEEN '$form_date' AND '$to_date'");
            }
            if ($doctor_id) {
                $this->db->where('OP.doctor_id', $doctor_id);
            }
            if ($reference_id) {
                $this->db->where('OP.reference_id', $reference_id);
            }
            if ($created_by) {
                $this->db->where('A.created_by', $created_by);
            }
            $this->db->where('OP.payment_status', 'complete');
            $this->db->order_by('OP.id', 'DESC');
        } else {
            $this->db->select('A.appointment_no, A.id as appointment_id, A.date as appointment_date, IP.id as invoice_id, IP.net_payable, IP.bill_date, IP.ipd_id, P.patient_unique_id, P.name as patient_name, P.phone, D.name as doctor, R.name as reference');
            $this->db->from('ipd_invoices AS IP');
            $this->db->join('ipd_patients AS IPD', 'IPD.id = IP.ipd_id', 'left');
            $this->db->join('patients AS P', 'P.user_id = IP.patient_id', 'left');
            $this->db->join('appointments AS A', 'A.patient_id = IP.patient_id', 'left');
            $this->db->join('employees AS D', 'D.user_id = IPD.doctor_id', 'left');
            $this->db->join('employees AS R', 'R.user_id = IPD.reference_id', 'left');
            $this->db->where('IP.payment_status', 'complete');
            if ($keyword) {
                $this->db->like('P.patient_unique_id', $keyword);
                $this->db->or_like('P.phone', $keyword, 'both');
                $this->db->or_like('P.name', $keyword, 'both');
            }
            if ($form_date && $to_date) {
                $this->db->where("DATE(IP.bill_date) BETWEEN '$form_date' AND '$to_date'");
            }
            if ($doctor_id) {
                $this->db->where('IPD.doctor_id', $doctor_id);
            }
            if ($reference_id) {
                $this->db->where('IP.commission_user_id', $reference_id);
            }
            if ($created_by) {
                $this->db->where('A.created_by', $created_by);
            }
            $this->db->order_by('IP.id', 'DESC');
        }
        return $this->db->get()->result();
    }

    public function get_single_doctor($doctor_id)
    {
        $this->db->select('A.*, E.name as doctor, E.specialist');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.doctor_id', 'left');
        if ($doctor_id) {
            $this->db->where('A.doctor_id', $doctor_id);
        }
        return $this->db->get()->row();
    }

    public function get_single_employee($user_id)
    {
        $this->db->select('A.*, E.name as employee, D.name as designation');
        $this->db->from('appointments AS A');
        $this->db->join('employees AS E', 'E.user_id = A.created_by', 'left');
        $this->db->join('designations AS D', 'D.id = E.designation_id', 'left');
        if ($user_id) {
            $this->db->where('A.created_by', $user_id);
        }
        return $this->db->get()->row();
    }


    public function get_patient_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by)
    {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.id as reference_id, R.name as reference');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('appointments AS A', 'A.id = I.appointment_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('I.marketing_id', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        $this->db->order_by('I.id', 'DESC');
        return $this->db->get()->result();
    }

    public function get_patient_test_list($invoice_id, $patient_id)
    {
        $this->db->select('ID.*, T.name as test_name');
        $this->db->from('invoice_details AS ID');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = ID.investagation_id', 'left');
        $this->db->where('I.id', $invoice_id);
        $this->db->where('I.patient_id', $patient_id);
        $this->db->where('I.payment_status', 'complete');
        return $this->db->get()->result();
    }

    public function get_vd_investigation_list($keyword, $type, $form_date, $to_date, $doctor_id, $reference_id, $created_by)
    {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient, P.phone, D.name as doctor, R.id as reference_id, R.name as reference, M.name as marketing_name');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        $this->db->join('employees AS R', 'R.user_id = I.commission_user_id', 'left');
        $this->db->join('employees AS M', 'M.user_id = R.marketing_id', 'left');
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        if ($keyword) {
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword, 'both');
            $this->db->or_like('P.phone', $keyword, 'both');
        }
        if ($type == 1) {
            $this->db->group_start();
            $this->db->where('I.commission_user_id', 0);
            $this->db->or_where('I.commission_user_id', NULL);
            $this->db->or_where('I.commission_user_id', '');
            $this->db->group_end();
        }
        if ($type == 2) {
            $this->db->where('I.commission_user_id >', 0);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        if ($reference_id) {
            $this->db->where('I.commission_user_id', $reference_id);
        }
        if ($created_by) {
            $this->db->where('R.marketing_id', $created_by);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->where('I.paid_status', 'paid');
        $this->db->order_by('I.id', 'DESC');
        return $this->db->get()->result();
    }
}
