<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Manufacturer_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_manufacturer_list($limit, $offset, $search, $count) {
        $this->db->select('M.*');
        $this->db->from('manufacturers AS M');
        if ($search) {
            $this->db->like('M.phone', $search, 'both');
            $this->db->or_like('M.name', $search, 'both');
            $this->db->or_like('M.note', $search, 'both');
        }
        $this->db->order_by('M.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function get_single_manufacturer($id) {
        $this->db->select('M.*, C.name as created_by, E.name as modified_by');
        $this->db->from('manufacturers AS M');
        $this->db->join('employees AS C', 'C.user_id = M.created_by', 'left');
        $this->db->join('employees AS E', 'E.user_id = M.modified_by', 'left');
        $this->db->where('M.id', $id);
        return $this->db->get()->row();
    }

    function duplicate_check($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('manufacturers')->num_rows();
    }
}
