<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('ipd'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/new'); ?>" class="btn btn-primary btn-sm mr-15">
                    <i class="fa fa-user-plus"></i>
                    <?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>

            <?php if (has_permission(ADD, 'ipd', 'ipd')) { ?>
                <a href="<?php echo site_url('ipd/admitted'); ?>" class="btn btn-success btn-sm">
                    <i class="fa fa-users"></i>
                    <?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('patient'); ?>
                </a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-bed font-30 mr-10"></i>
                            <?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php echo form_open_multipart(site_url('ipd/discharge'), array('name' => 'search', 'id' => 'search', 'class' => 'needs-validation form-inline', 'novalidate' => 'novalidate', 'method' => 'get'), ''); ?>
                    <div class="form-group">
                        <div class="input-group input-group-sm">
                            <input type="text" class="form-control" name="search" id="search" value="<?php echo isset($search) ?  $search : ''; ?>" placeholder="<?php echo $this->lang->line('search'); ?>">
                            <div class="input-group-append">
                                <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('search'); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('discharge'); ?> <?php echo $this->lang->line('date'); ?></th>
                                        <th><?php echo $this->lang->line('admission_id'); ?></th>
                                        <th><?php echo $this->lang->line('patient_id'); ?></th>
                                        <th><?php echo $this->lang->line('name'); ?></th>
                                        <th><?php echo $this->lang->line('ref_by'); ?></th>
                                        <th><?php echo $this->lang->line('admitted'); ?> <?php echo $this->lang->line('ward'); ?></th>
                                        <th><?php echo $this->lang->line('bed'); ?></th>
                                        <th><?php echo $this->lang->line('charge'); ?></th>
                                        <th><?php echo $this->lang->line('payment'); ?></th>
                                        <th width="15%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($patients) && !empty($patients)) { ?>
                                        <?php foreach ($patients as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->admission_date)); ?></td>
                                                <td><?php echo date('d/m/Y h:i A', strtotime($obj->discharged_date)); ?></td>
                                                <td><?php echo $obj->ipd_no; ?></td>
                                                <td><?php echo $obj->patient_unique_id; ?></td>
                                                <td>
                                                    <a href="<?php echo site_url('ipd/profile/' . $obj->id); ?>">
                                                        <?php echo $obj->patient_name; ?>
                                                    </a>
                                                </td>
                                                <td><?php echo $obj->doctor_name; ?></td>
                                                <td><?php echo $obj->ward_name; ?></td>
                                                <td>
                                                    <i class="fa fa-bed text-green"></i>
                                                    <?php echo $obj->bed; ?> - <?php echo $obj->floor; ?>
                                                </td>
                                                <td><?php echo $obj->total_bill; ?></td>
                                                <td><?php echo $obj->advanced; ?></td>
                                                <td>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <button type="button" class="btn btn-xs btn-orange" onclick="printBill('<?php echo $obj->id; ?>')">
                                                            <i class="fa fa-print"></i>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <button type="button" class="btn btn-xs btn-primary" onclick="printConsent('<?php echo $obj->id; ?>')">
                                                            <i class="fa fa-print"></i> <?php echo $this->lang->line('consent'); ?>
                                                        </button>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <a href="<?php echo site_url('ipd/invoice/' . $obj->id . '/' . $obj->invoice_id); ?>" class="btn btn-xs btn-primary"><i class="fa fa-eye"></i> <?php echo $this->lang->line('invoice'); ?></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd')) { ?>
                                                        <a class="btn btn-xs btn-info" href="<?php echo site_url('ipd/profile/' . $obj->id); ?>">
                                                            <i class="fa fa-eye"></i>
                                                        </a>
                                                    <?php } ?>
                                                    <?php if (has_permission(VIEW, 'ipd', 'ipd_discharged_sms')) { ?>
                                                        <button type="button" onclick="send_sms(<?php echo $obj->id; ?>);" class="btn btn-warning btn-xs">
                                                            <i class="fa fa-envelope-o"></i>
                                                        </button>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="12"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script>
 function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }
    function printConsent(id) {
        $.ajax({
            url: '<?php echo site_url('ipd/consent'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });

    function send_sms(id) {
        $.confirm({
            title: 'Send SMS!',
            content: 'Are you sure to send SMS?',
            type: 'red',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Yes',
                    btnClass: 'btn-red',
                    action: function() {
                        $.ajax({
                            url: "<?php echo site_url('ipd/ipd_discharged_sms'); ?>/" + id,
                            method: 'get'
                        });
                        $.alert('SMS Sent Successfully!');
                    }
                },
                close: function() {}
            }
        });
    }
</script>