<!DOCTYPE html>
<html>

<head>
    <title>IPD</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            margin-top: 100px;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .signature tbody td {
            padding: 15px 0;
            vertical-align: left;
            font-size: 16px;
        }

        p {
            text-align: justify;
            line-height: 30px;
            font-size: 16px;
        }
        table{
            width:100%;
            border-collapse: collapse;
        }
        table td{
            font-size:16px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table>
                <tr>
                    <td width="30%" align="left">Patient ID: <?php echo $patient->patient_unique_id; ?></td>
                    <td width="40%" align="center">IPD Reg. No: <?php echo $patient->registration_no; ?></td>
                    <td width="30%" align="right">Cabin/Bed: <?php echo $patient->bed; ?></td>
                </tr>
            </table>
            <table>
                <tr>
                    <td width="50%" align="left">Admitted Time: <?php echo $patient->admission_date ? date('d/m/Y h:ia', strtotime($patient->admission_date)) : ''; ?></td>
                    <td width="50%" align="right">Printed Time: <?php echo date('d M, Y h:ia'); ?></td>
                </tr>
            </table>
            <p style="margin-top:10px">
                রোগীর নাম <?php echo $patient->patient_name; ?>,
                বয়স <?php echo floor((time() - strtotime($patient->dob)) / 31556926); ?>Y
                লিঙ্গ <?php echo $this->lang->line($patient->gender); ?>
                পিতা/স্বামী/অভিভাবকের নাম <?php echo $patient->guardian_name; ?>
                আমি আমার নিজের/পিতার/মাতার/স্ত্রীর/পুত্রের/কন্যার <?php echo $patient->case; ?>
                অস্ত্রোপচার সম্পন্ন করার জন্য <?php echo !empty($surgeon->doctor) ? '<b>' . $surgeon->doctor . '</b>' : '...................................................................................................'; ?>
                <?php echo !empty($surgeon->specialist) ? '<b>' . $surgeon->specialist . '</b>' : ''; ?>
                কে এবং তার নির্বাচিত সহকারীদের মনোনীত করছি। যদি অস্ত্রোপচার প্রক্রিয়ার মধ্যে কোন নতুন পরিস্থিতি, জটিলতা ও উপসর্গ দেখা দেয় তবে সে ক্ষেত্রে বাস্তব অবস্থার পরিপ্রেক্ষিতে প্রয়োজনীয় সিদ্ধান্ত ও ব্যবস্থা গ্রহনের জন্য আমি তার উপর আস্থা রাখছি।
            </p>
            <p>
                উপরোক্ত অস্ত্রোপচারের  উদ্দেশ্যে এবং প্রকৃত চিকিৎসা সংক্রান্ত বিকল্প পদ্ধতি, এই সংক্রান্ত ঝুকি এবং এর সাথে জড়িত যা কিছু জটিলতা সে সব পুরোপুরিভাবে আমার কাছে ব্যাখ্যা করা হয়েছে এবং আমকে এই মর্মে অবহিত করা হয়েছে যে অস্ত্রোপচারের ফলাফল অনুকুল না ও হতে পারে।
            </p>
            <p>
                অস্ত্রোপচার চলাকালীন সময়ে এ্যানেসথেসিয়ায় আমার সম্মতিক্রমে
                <?php echo !empty($anesthesias->doctor) ? '<b>' . $anesthesias->doctor . '</b>' : '...................................................................................................'; ?>
                <?php echo !empty($anesthesias->specialist) ? '<b>' . $anesthesias->specialist . '</b>' : ''; ?>
                কে দেয়া হচ্ছে এবং এ ব্যাপারে প্রয়োজন মত পদক্ষেপ গ্রহন করবেন।
            </p>
            <p>
                আমি এই মর্মে নিশ্চয়তা দিচ্ছি যে, আমি অস্ত্রোপচার সংক্রান্ত উক্ত সম্মতিপত্র পুরোপুরি পড়েছি/ আমাকে পড়ে শোনানো হয়েছে এবং সংশ্লিষ্ট প্রয়োজনীয় বিষয়গুলো যথাযথভাবে আমাকে ব্যাখ্যা করা হয়েছে।
            </p>


            <table class="table signature" style="margin-top: 70px;">
                <tbody>
                    <tr>
                        <td width="70%"><b>রোগী/রোগীর আত্মীয়/অভিভাবকের স্বাক্ষর</b></td>
                        <td width="30%"><b>Prepared By:</b></td>
                    </tr>
                    <tr>
                        <td style="padding-top: 5px;"></td>
                        <td style="padding-top: 5px;"><?php echo $patient->created_by; ?></td>
                    </tr>
                    <tr>
                        <td colspan="2">১। স্বাক্ষর......................................................</td>
                    </tr>
                    <tr>
                        <td colspan="2">নামঃ</td>
                    </tr>
                    <tr>
                        <td colspan="2">২। স্বাক্ষর......................................................</td>
                    </tr>
                    <tr>
                        <td colspan="2">নামঃ</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>

</html>