<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item" aria-current="page"><?php echo $this->lang->line('ipd'); ?></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('booking'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <?php echo form_open_multipart(site_url('ipd/booking/add'), array('name' => 'add', 'id' => 'add', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(ADD, 'ipd', 'booking')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-user-plus font-30 mr-10"></i>
                            <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('booking'); ?>
                        </h6>
                    <?php } ?>
                    <div class="align-items-center">
                        <?php if (has_permission(VIEW, 'ipd', 'booking')) { ?>
                            <a href="<?php echo site_url('ipd/booking'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        <?php } ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('date'); ?> <span class="required">*</span></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('date'); ?>" required autocomplete="off">
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="date" class="form-text text-muted">
                                <?php echo form_error('date'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="bed_group_id"><?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('ward'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_group_id" id="bed_group_id" required onchange="get_bed(this.value)">
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($bed_groups as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_group_id) && $bed_group_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->floor_name; ?>]</option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_group_id" class="form-text text-muted">
                                <?php echo form_error('bed_group_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="bed_id"><?php echo $this->lang->line('bed'); ?> <?php echo $this->lang->line('number'); ?> <span class="required">*</span></label>
                            <select class="form-control custom-select select2" name="bed_id" id="bed_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php foreach ($beds as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($bed_id) && $bed_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="bed_id" class="form-text text-muted">
                                <?php echo form_error('bed_id'); ?>
                            </small>
                        </div>
                        <div class="col-md-6 mb-10">
                            <label for="booking_id"><?php echo $this->lang->line('existing'); ?> <?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('person'); ?></label>
                            <select class="form-control custom-select select2" name="booking_id" id="booking"></select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="booking_name"><?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('booking'); ?> <?php echo $this->lang->line('person'); ?></label>
                            <input type="text" class="form-control" name="booking_name" id="booking_name" value="<?php echo isset($booking_name) ?  $booking_name : ''; ?>" placeholder="<?php echo $this->lang->line('person'); ?> <?php echo $this->lang->line('name'); ?>" autocomplete="off">
                            <small id="booking_name" class="form-text text-muted">
                                <?php echo form_error('booking_name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="phone"><?php echo $this->lang->line('person'); ?> <?php echo $this->lang->line('phone'); ?></label>
                            <input type="number" min="0" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('person'); ?> <?php echo $this->lang->line('phone'); ?>" autocomplete="off">
                            <small id="phone" class="form-text text-muted">
                                <?php echo form_error('phone'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="patient_id"><?php echo $this->lang->line('existing'); ?> <?php echo $this->lang->line('patient'); ?></label>
                            <select class="form-control custom-select select2" name="patient_id" id="patient"></select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="name"><?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('new'); ?> <?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?>" autocomplete="off">
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>" autocomplete="off">
                            <small id="address" class="form-text text-muted">
                                <?php echo form_error('address'); ?>
                            </small>
                        </div>
                    </div>
                    <div class="col-md-12 mb-10">
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                            </div>
                            <textarea class="form-control" name="remark" id="remark" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($remark) ?  $remark : ''; ?></textarea>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Card Footer -->
            <div class="card-footer pt-0">
                <div class="button-list">
                    <a class="btn btn-gradient-danger" href="<?php echo site_url('ipd/booking'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                    <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('submit'); ?></button>
                </div>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();

    $('#date').daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        autoApply: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>

<script>
    function get_bed(bed_group_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('ajax/get_bed_group_by_bed'); ?>",
            data: {
                bed_group_id: bed_group_id
            },
            async: false,
            success: function(response) {
                if (response) {
                    $('#bed_id').html(response);
                }
            }
        });
    };
</script>

<script>
    $("#booking").select2({
        ajax: {
            url: "<?php echo site_url('ipd/booking/employee'); ?>",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    q: params.term
                };
            },
            processResults: function(data, params) {
                return {
                    results: getEmployeeData(data)
                };
            },
            cache: true
        },
        placeholder: 'Search for a booking person',
        minimumInputLength: 1
    });

    function getEmployeeData(items) {
        let data = [];
        for (let i = 0; i < items.length; i++) {
            let name = items[i].name;
            let phone = items[i].phone;
            let text = `${name} [${phone}]`;
            data.push({
                id: items[i].id,
                text: text
            });
        }
        return data;
    }
</script>

<script>
    $("#patient").select2({
        ajax: {
            url: "<?php echo site_url('ipd/booking/patient'); ?>",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    q: params.term
                };
            },
            processResults: function(data, params) {
                return {
                    results: getPatientData(data)
                };
            },
            cache: true
        },
        placeholder: 'Search for a patient',
        minimumInputLength: 1
    });

    function getPatientData(items) {
        let data = [];
        for (let i = 0; i < items.length; i++) {
            let name = items[i].name;
            let patient_unique_id = items[i].patient_unique_id;
            let phone = items[i].phone;
            let text = `${name} [${patient_unique_id}], ${phone}`;
            data.push({
                id: items[i].id,
                text: text
            });
        }
        return data;
    }
</script>