<!--Add Appointment Modal-->
<div class="modal fade" id="addAppointmentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title mr-30"><?php echo $this->lang->line('add') . " " . $this->lang->line('appointment'); ?></h5>
                <?php if (has_permission(ADD, 'hrm', 'employee')) { ?>
                    <button type="button" onclick="addAppointmentModalClose()" data-toggle="modal" data-target="#addEmployeeModal" class="btn btn-primary btn-xs">
                        <i class="fa fa-user font-12 mr-5"></i> <?php echo $this->lang->line('add'); ?> <?php echo $this->lang->line('reference'); ?>
                    </button>
                <?php } ?>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <?php echo form_open_multipart(site_url('frontoffice/appointment/add'), array('name' => 'addAppointmentForm', 'id' => 'addAppointmentForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-4 mb-10">
                        <label for="name"><?php echo $this->lang->line('name'); ?> <span class="required">*</span></label>
                        <input type="text" class="form-control" name="name" id="add_name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-10">
                        <label for="gender"><?php echo $this->lang->line('gender'); ?> <span class="required">*</span></label>
                        <select class="form-control custom-select" name="gender" id="add_gender" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            <?php $genders = get_genders(); ?>
                            <?php foreach ($genders as $key => $value) { ?>
                                <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-10">
                        <label for="phone"><?php echo $this->lang->line('phone'); ?> <span class="required">*</span></label>
                        <input type="number" class="form-control" name="phone" id="add_phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-3 mb-10">
                        <label for="date"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?> <span class="required">*</span></label>
                        <input type="text" class="form-control" name="date" id="add_date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?> <span class="required">*</span></label>
                        <select class="form-control select2" name="doctor_id" id="add_doctor_id" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                            <?php foreach ($doctors as $obj) { ?>
                                <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="reference_id"><?php echo $this->lang->line('reference'); ?> <span class="required">*</span></label>
                        <select class="form-control select2" name="reference_id" id="add_reference_id" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                            <?php foreach ($references as $obj) { ?>
                                <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-5 mb-10">
                        <label for="address"><?php echo $this->lang->line('address'); ?></label>
                        <input type="text" class="form-control" id="add_address" name="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                    </div>
                    <div class="col-md-5 mb-10">
                        <label for="address"><?php echo $this->lang->line('remark'); ?></label>
                        <input type="text" class="form-control" id="add_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                    </div>
                    <div class="col-md-2 mb-10">
                        <label for="appointment_status"><?php echo $this->lang->line('status'); ?></label>
                        <select class="form-control custom-select" name="appointment_status" id="add_appointment_status">
                            <?php $appointment_status = get_appointment_status(); ?>
                            <?php foreach ($appointment_status as $key => $value) { ?>
                                <option value="<?php echo $key; ?>" <?php echo isset($appointment_status) && $appointment_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="patient_id" name="patient_id">
                <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="submit" class="btn btn-gradient-primary"><?php echo $this->lang->line('submit'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    function getPhone() {
        var phone = document.getElementById("get_phone").value;
        $('#add_phone').val(phone);
    }

    function addAppointment(id) {
        $.ajax({
            url: '<?php echo site_url('frontoffice/appointment/get_patient/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#patient_id').val(data.user_id);
                $('#add_name').val(data.name);
                $('#add_phone').val(data.phone);
                $('#add_gender').val(data.gender);
                $('#add_address').val(data.address);
                $('#add_note').val(data.note);
            }
        });
    }

    $(document).ready(function(e) {
        $("#addAppointmentForm").on('submit', (function(e) {
            e.preventDefault();
            if ($("#add_name").val() != "" && $("#add_phone").val() != "" && $("#add_doctor_id").val() != "" && $("#add_gender").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('frontoffice/appointment/add') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            window.location.href = "<?php echo site_url('frontoffice/appointment'); ?>";
                        }
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>


<!-- Edit Appointment Modal -->
<div class="modal fade" id="editAppointmentModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content modal-media-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo $this->lang->line('edit') . " " . $this->lang->line('appointment'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <?php echo form_open_multipart(site_url('frontoffice/appointment/edit'), array('name' => 'editAppointmentForm', 'id' => 'editAppointmentForm', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
            <div class="modal-body">
                <div class="form-row">
                    <div class="col-md-4 mb-10">
                        <label for="name"><?php echo $this->lang->line('name'); ?></label>
                        <input type="text" class="form-control" name="name" id="edit_name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-10">
                        <label for="gender"><?php echo $this->lang->line('gender'); ?></label>
                        <select class="form-control custom-select" name="gender" id="edit_gender" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                            <?php $genders = get_genders(); ?>
                            <?php foreach ($genders as $key => $value) { ?>
                                <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-10">
                        <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                        <input type="number" class="form-control search_phone" name="phone" id="edit_phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required>
                    </div>
                    <div class="col-md-3 mb-10">
                        <label for="date"><?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?></label>
                        <input type="text" class="form-control" name="date" id="edit_date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('appointment'); ?> <?php echo $this->lang->line('date'); ?>" required autocomplete="off">
                    </div>
                    <div class="col-md-6 mb-10">
                        <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                        <select class="form-control select2" name="doctor_id" id="edit_doctor_id" required>
                            <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                            <?php foreach ($doctors as $obj) { ?>
                                <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                            <?php } ?>
                        </select>
                    </div>
                    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || $this->session->userdata('role_id') == ADMIN || !empty(custom_permission('modified_by'))) { ?>
                        <div class="col-md-6 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control select2" name="reference_id" id="edit_reference_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" id="edit_address" name="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" id="edit_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="appointment_status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="appointment_status" id="edit_appointment_status">
                                <?php $appointment_status = get_appointment_status(); ?>
                                <?php foreach ($appointment_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($appointment_status) && $appointment_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="is_opd"><?php echo $this->lang->line('opd'); ?></label>
                            <select class="form-control custom-select" name="is_opd" id="edit_is_opd" required>
                                <option value="0" <?php echo isset($is_opd) && $is_opd == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                                <option value="1" <?php echo isset($is_opd) && $is_opd == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                            </select>
                        </div>
                    <?php } else { ?>
                        <div class="col-md-6 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" id="edit_address" name="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                        </div>
                        <div class="col-md-8 mb-10">
                            <label for="note"><?php echo $this->lang->line('remark'); ?></label>
                            <input type="text" class="form-control" id="edit_note" name="note" value="<?php echo isset($note) ?  $note : ''; ?>" placeholder="<?php echo $this->lang->line('remark'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="appointment_status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="appointment_status" id="edit_appointment_status">
                                <?php $appointment_status = get_appointment_status(); ?>
                                <?php foreach ($appointment_status as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($appointment_status) && $appointment_status == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="is_opd"><?php echo $this->lang->line('opd'); ?></label>
                            <select class="form-control custom-select" name="is_opd" id="edit_is_opd" required>
                                <option value="0" <?php echo isset($is_opd) && $is_opd == 0 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no'); ?></option>
                                <option value="1" <?php echo isset($is_opd) && $is_opd == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('yes'); ?></option>
                            </select>
                        </div>
                    <?php } ?>
                    <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || $this->session->userdata('role_id') == ADMIN || !empty(custom_permission('created_by'))) { ?>
                        <div class="col-md-6 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control select2" name="created_by" id="edit_created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>"><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="edit_patient_id" name="patient_id">
                <input type="hidden" id="edit_id" name="id">
                <button type="button" class="btn btn-gradient-danger" data-dismiss="modal"><?php echo $this->lang->line('cancel'); ?></button>
                <button type="submit" id="editAppointmentSubmitBtn" class="btn btn-gradient-primary"><?php echo $this->lang->line('update'); ?></button>
            </div>
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script>
    function editAppointment(id) {
        $.ajax({
            url: '<?php echo site_url('frontoffice/appointment/get_appointment/') ?>' + id,
            dataType: 'json',
            success: function(data) {
                $('#edit_id').val(data.id);
                $('#edit_patient_id').val(data.user_id);
                $('#edit_name').val(data.name);
                $('#edit_phone').val(data.phone);
                $('#edit_date').val(data.date);
                $('#edit_gender').val(data.gender);
                $('#edit_address').val(data.address);
                $('#edit_note').val(data.note);
                $('#edit_is_opd').val(data.is_opd);
                $('#edit_appointment_status').val(data.appointment_status);
                $('#edit_doctor_id').val(data.doctor_id).trigger('change');
                $('#edit_reference_id').val(data.reference_id).trigger('change');
                $('#edit_created_by').val(data.created_by).trigger('change');
            }
        });
    }

    $(document).ready(function(e) {
        $("#editAppointmentForm").on('submit', (function(e) {
            e.preventDefault();
            if ($("#edit_name").val() != "" && $("#edit_phone").val() != "" && $("#edit_doctor_id").val() != "" && $("#edit_gender").val() != "") {
                $.ajax({
                    url: '<?php echo site_url('frontoffice/appointment/edit') ?>',
                    type: "POST",
                    data: new FormData(this),
                    dataType: 'json',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        if (data.status == "failed") {
                            var message = "";
                            $.each(data.error, function(index, value) {
                                $("." + index).html(value);
                                message += value;
                            });
                            $.toast({
                                text: message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-danger',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                        } else {
                            $.toast({
                                text: data.message,
                                position: 'top-right',
                                loaderBg: '#7a5449',
                                class: 'jq-toast-primary',
                                hideAfter: 3500,
                                stack: 6,
                                showHideTransition: 'fade'
                            });
                            location.reload(true);
                            //window.location.href = "<?php echo site_url('frontoffice/appointment'); ?>";
                        }
                        $('#editAppointmentForm').find('form')[0].reset();
                    },
                    error: function() {
                        alert("Fail")
                    }
                });
            } else {
                $.toast({
                    text: "Please select all required field",
                    position: 'top-right',
                    loaderBg: '#7a5449',
                    class: 'jq-toast-danger',
                    hideAfter: 3500,
                    stack: 6,
                    showHideTransition: 'fade'
                });
            }
        }));
    });
</script>