<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Testimonial_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_testimonial_list($limit, $offset, $keyword, $count) {
        $this->db->select('T.*');
        $this->db->from('testimonials AS T');
        if ($keyword) {
            $this->db->like('T.name', $keyword, 'both');
            $this->db->or_like('T.designation', $keyword, 'both');
            $this->db->or_like('T.message', $keyword, 'both');
            $this->db->or_like('T.bn_message', $keyword, 'both');
        }
        $this->db->order_by('T.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }
}
