<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('schedule'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_schedule'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('doctor/schedule'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="slot"><?php echo $this->lang->line('slot'); ?></label>
                            <select class="form-control custom-select" name="slot" id="slot">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('slot'); ?></option>
                                <?php $slots = get_schedule_slot(); ?>
                                <?php foreach ($slots as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($slot) && $slot == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="status" id="status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('status'); ?></option>
                                <option value="1" <?php echo isset($status) && $status == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('in_active'); ?></option>
                                <option value="2" <?php echo isset($status) && $status == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('active'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(VIEW, 'doctor', 'schedule')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-clock-o font-30 mr-10"></i>
                            <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('list'); ?>
                        </h6>
                    <?php } ?>

                    <?php if (has_permission(ADD, 'doctor', 'schedule')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('doctor/schedule/single'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('single'); ?> <?php echo $this->lang->line('schedule'); ?>
                            </a>

                            <a href="<?php echo site_url('doctor/schedule/add'); ?>" class="btn btn-xs btn-success">
                                <i class="fa fa-plus font-12 mr-5"></i>
                                <?php echo $this->lang->line('multiple'); ?> <?php echo $this->lang->line('schedule'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <div class="card-body">
                    <div class="table-wrap">
                        <div class="table-responsive">
                            <table class="table table-sm mb-0">
                                <thead>
                                    <tr>
                                        <th width="5%"><?php echo $this->lang->line('sl_no'); ?></th>
                                        <th width="25%"><?php echo $this->lang->line('doctor'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('slot'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('date'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('start_time'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('end_time'); ?></th>
                                        <th width="5%"><?php echo $this->lang->line('status'); ?></th>
                                        <th width="15%"><?php echo $this->lang->line('remark'); ?></th>
                                        <th width="10%"><?php echo $this->lang->line('action'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (isset($schedules) && !empty($schedules)) { ?>
                                        <?php foreach ($schedules as $obj) { ?>
                                            <tr>
                                                <td><?php echo $sl_count; ?></td>
                                                <td><?php echo $obj->doctor; ?></td>
                                                <td><?php echo $this->lang->line($obj->slot); ?></td>
                                                <td>
                                                    <?php
                                                    echo $obj->date ? date('d-m-Y', strtotime($obj->date)) : '';
                                                    echo  '<br/>';
                                                    echo $obj->date ? date('l', strtotime($obj->date)) : '';
                                                    ?>
                                                </td>
                                                <td><?php echo $obj->start_time ? date('h:ia', strtotime($obj->start_time)) : ''; ?></td>
                                                <td><?php echo $obj->end_time ? date('h:ia', strtotime($obj->end_time)) : ''; ?></td>
                                                <td><?php echo $obj->status ? '<span class="badge badge-success">' . $this->lang->line('active') . '</span>' : '<span class="badge badge-danger">' . $this->lang->line('in_active') . '</span>'; ?></td>
                                                <td><?php echo word_limiter($obj->remark, 10); ?></td>
                                                <td>
                                                    <?php if (has_permission(EDIT, 'doctor', 'schedule')) { ?>
                                                        <a class="btn btn-xs btn-success" href="<?php echo site_url('doctor/schedule/single/' . $obj->id); ?>"><i class="fa fa-pencil-square-o"></i></a>
                                                    <?php } ?>
                                                    <?php if (has_permission(DELETE, 'doctor', 'schedule')) { ?>
                                                        <a class="btn btn-xs btn-danger" href="<?php echo site_url('doctor/schedule/delete/' . $obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');"> <i class="fa fa-trash text-white"></i></a>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                            <?php $sl_count++; ?>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <tr class="text-center">
                                            <td colspan="9"><?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <?php if ($this->pagination->create_links()) { ?>
                    <div class="card-footer justify-content-end">
                        <?php echo $this->pagination->create_links(); ?>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>