<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Report_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }

    public function get_doctor_list() {
        $this->db->select('C.*, E.name, E.phone, E.user_id');
        $this->db->from('doctor_charges AS C');
        $this->db->join('employees AS E', 'E.user_id = C.doctor_id', 'left');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('U.role_id', DOCTOR);
        $this->db->where('E.status', 1);
        $this->db->order_by('E.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_invoice_test_list($limit, $offset, $keyword, $form_date, $to_date, $doctor_id, $count) {
        $this->db->select('I.*, P.patient_unique_id, P.name as patient_name, P.phone, D.name as ref_by');
        $this->db->from('invoices AS I');
        $this->db->join('patients AS P', 'P.user_id = I.patient_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword);
            $this->db->or_like('P.phone', $keyword);
            $this->db->or_like('I.custom_invoice_id', $keyword);
            $this->db->group_end();
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(I.bill_date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        $this->db->where('I.payment_status', 'complete');
        $this->db->order_by('I.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_report_list($limit, $offset, $keyword, $form_date, $to_date, $doctor_id, $count) {
        $this->db->select('R.*, I.custom_invoice_id, I.bill_date, I.ref_dr_name, I.self, I.ref_dr_id, P.patient_unique_id, P.name as patient_name, P.phone, D.name as ref_by');
        $this->db->from('diagnostic_reports AS R');
        $this->db->join('patients AS P', 'P.user_id = R.patient_id', 'left');
        $this->db->join('invoices AS I', 'I.id = R.invoice_id', 'left');
        $this->db->join('employees AS D', 'D.user_id = I.ref_dr_id', 'left');
        if ($keyword) {
            $this->db->group_start();
            $this->db->like('P.patient_unique_id', $keyword);
            $this->db->or_like('P.name', $keyword);
            $this->db->or_like('P.phone', $keyword);
            $this->db->or_like('I.custom_invoice_id', $keyword);
            $this->db->group_end();
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(R.created_at) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($doctor_id) {
            $this->db->where('I.ref_dr_id', $doctor_id);
        }
        //$this->db->where('R.template_status', 1);
        $this->db->where('R.sample_collect', 1);
        $this->db->group_by('R.invoice_id');
        $this->db->order_by('R.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_test_list($invoice_id, $patient_id) {
        $this->db->select('ID.*, DT.name as test_name');
        $this->db->from('invoice_details AS ID');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
      	
        $this->db->where('I.patient_id', $patient_id);
        $this->db->order_by('DT.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_sample_collect_list($invoice_id, $patient_id) {
        $this->db->select('DR.*, DT.name as test_name, T.name as template_name');
        $this->db->from('diagnostic_reports AS DR');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = DR.investagation_id', 'left');
        $this->db->join('diagnostic_templates AS T', 'T.id = DR.template_id', 'left');
        $this->db->where('DR.invoice_id', $invoice_id);
        $this->db->where('DR.patient_id', $patient_id);
        $this->db->order_by('DT.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_invoice_by_test_list($invoice_id) {
        $this->db->select('ID.*, ID.investagation_id, D.name as department, D.id as department_id, G.name as group, DT.name as test_name, I.patient_id');
        $this->db->from('invoice_details AS ID');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = ID.investagation_id', 'left');
        $this->db->join('diagnostic_departments AS D', 'D.id = DT.department_id', 'left');
        $this->db->join('diagnostic_groups AS G', 'G.id = DT.group_id', 'left');
        $this->db->join('invoices AS I', 'I.id = ID.invoice_id', 'left');
        $this->db->where('ID.invoice_id', $invoice_id);
        // if ($this->session->userdata('role_id') == PATHOLOGIST) {
        //     $this->db->where('D.id', 1);
        // }
        // if ($this->session->userdata('role_id') == RADIOLOGIST) {
        //     $this->db->where('D.id', 2);
        // }
      	$this->db->where_in('D.id', 1,6,10);
        $this->db->order_by('DT.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_invoice_by_report_list($invoice_id) {
        $this->db->select('DR.*, DR.id as report_id, DT.name as test_name, T.name as template_name');
        $this->db->from('diagnostic_reports AS DR');
        $this->db->join('diagnostic_tests AS DT', 'DT.id = DR.investagation_id', 'left');
        $this->db->join('diagnostic_templates AS T', 'T.id = DR.template_id', 'left');
        $this->db->where('DR.invoice_id', $invoice_id);
        // if ($this->session->userdata('role_id') == PATHOLOGIST) {
        //     $this->db->where('DR.department_id', 1);
        // }
        // if ($this->session->userdata('role_id') == RADIOLOGIST) {
        //     $this->db->where('DR.department_id', 2);
        // }
        $this->db->where('DR.template_status', '1');
        $this->db->order_by('DR.id', 'ASC');
        return $this->db->get()->result();
    }

    public function get_print_report($report_id) {
        $this->db->select('DR.*, DR.note as remark, DR.modified_at, DT.name as dtname, T.name as tname, T.specimen, G.name as group, P.created_at as createdpatient, P.patient_unique_id, P.name as patient, P.dob, P.gender, P.phone as mobile, I.created_at as billcreate, I.custom_invoice_id, I.ref_dr_id, I.ref_dr_name, I.self, E.name as doctor, E.specialist');
        $this->db->from('diagnostic_reports AS DR');
        $this->db->join('diagnostic_templates AS DT', 'DT.id = DR.template_id', 'left');
        $this->db->join('diagnostic_tests AS T', 'T.id = DR.investagation_id', 'left');
      	$this->db->join('diagnostic_groups AS G', 'G.id = T.group_id', 'left');
        $this->db->join('patients AS P', 'P.user_id = DR.patient_id', 'left');
        $this->db->join('invoices AS I', 'I.id = DR.invoice_id', 'left');
        $this->db->join('employees AS E', 'E.user_id = I.ref_dr_id', 'left');
        $this->db->where('DR.id ', $report_id);
        return $this->db->get()->row();
    }

    /*****************Function get_total_purchase_quantity**********************************
     * @type            : Function
     * @function name   : get_total_purchase_quantity
     * @description     : Get total purchase quantity for a medicine
     *
     * @param           : $medicine_id integer
     * @return          : integer
     * ********************************************************** */
    public function get_total_purchase_quantity($medicine_id) {
        $this->db->select('SUM(MPD.quantity) AS total_purchase');
        $this->db->from('medicine_purchase_details AS MPD');
        $this->db->join('medicine_purchases AS MP', 'MP.id = MPD.purchase_id', 'left');
        $this->db->where('MPD.medicine_id', $medicine_id);
        $this->db->where('MP.payment_status', 'complete');
        $result = $this->db->get()->row();
        return $result ? $result->total_purchase : 0;
    }

    /*****************Function get_total_sale_quantity**********************************
     * @type            : Function
     * @function name   : get_total_sale_quantity
     * @description     : Get total sale quantity for a medicine
     *
     * @param           : $medicine_id integer
     * @return          : integer
     * ********************************************************** */
    public function get_total_sale_quantity($medicine_id) {
        $this->db->select('SUM(MID.quantity) AS total_sale');
        $this->db->from('medicine_invoice_details AS MID');
        $this->db->join('medicine_invoices AS MI', 'MI.id = MID.invoice_id', 'left');
        $this->db->where('MID.medicine_id', $medicine_id);
        $this->db->where('MI.payment_status', 'complete');
        $result = $this->db->get()->row();
        return $result ? $result->total_sale : 0;
    }

}