<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Notice.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Notice
 * @description     : Manage notice.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Notice extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Notice_Model', 'notice', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Notice List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if ($_GET && $this->input->get('date')) {
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            $exp = explode('-', $date);
            $form_date = date('Y-m-d', strtotime($exp[0]));
            $to_date = date('Y-m-d', strtotime($exp[1]));
            $role_id = $this->input->get('role_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('announcement/notice/?keyword=' . $keyword . '&date=' . $date . '&role_id=' . $role_id . '&created_by=' . $created_by);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }
            $config['total_rows'] = $this->notice->get_notice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $role_id, $created_by, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['notices'] = $this->notice->get_notice_list($config['per_page'], $offset, $keyword, $form_date, $to_date, $role_id, $created_by, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));

            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['role_id'] = $role_id;
            $this->data['created_by'] = $created_by;
        } else {
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->notice->get_notice_list($config['per_page'], $offset, null, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['notices'] = $this->notice->get_notice_list($config['per_page'], $offset, null, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        }

        $this->data['roles'] = $this->notice->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['employees'] = $this->notice->get_employee_list();
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('manage_notice') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('notice/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new Notice" user interface
     *                    and process to store "notices" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {
            $this->_prepare_notice_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_notice_data();
                $insert_id = $this->notice->insert('notices', $data);
                if ($insert_id) {
                    create_log('Has been created a Notice : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('announcement/notice');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('announcement/notice/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['roles'] = $this->notice->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('notice') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('notice/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load Update "Notice" user interface
     *                    with populate "Notice" value
     *                    and process to update "notices" into database
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function edit($id = null) {

        check_permission(EDIT);

        if ($_POST) {
            $this->_prepare_notice_validation();
            if ($this->form_validation->run() === TRUE) {
                $data = $this->_get_posted_notice_data();
                $updated = $this->notice->update('notices', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a Notice : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('announcement/notice');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('announcement/notice/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['notice'] = $this->notice->get_single('notices', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['notice'] = $this->notice->get_single('notices', array('id' => $id));
                if (!$this->data['notice']) {
                    redirect('announcement/notice');
                }
            }
        }

        $this->data['roles'] = $this->notice->get_list('roles', array('status' => 1), '', '', '', 'id', 'ASC');
        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('notice') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('notice/edit', $this->data);
    }


    /*     * ***************Function get_single_notice**********************************
     * @type            : Function
     * @function name   : get_single_notice
     * @description     : "Load single notice information" from database                  
     *                    to the user interface   
     * @param           : null
     * @return          : null 
     * ********************************************************** */

    public function get_single_notice() {
        $id = $this->input->post('id');
        $this->data['notice'] = $this->notice->get_single_notice($id);
        echo $this->load->view('notice/view', $this->data);
    }

    /*****************Function _prepare_notice_validation**********************************
     * @type            : Function
     * @function name   : _prepare_notice_validation
     * @description     : Process "Notice" user input data validation
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    private function _prepare_notice_validation() {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
        $this->form_validation->set_rules('title', $this->lang->line('title'), 'trim|required');
        $this->form_validation->set_rules('date', $this->lang->line('date'), 'trim|required');
    }

    /*****************Function _get_posted_notice_data**********************************
     * @type            : Function
     * @function name   : _get_posted_notice_data
     * @description     : Prepare "Notice" user input data to save into database
     *
     * @param           : null
     * @return          : $data array(); value
     * ********************************************************** */
    private function _get_posted_notice_data() {

        $items = array();
        $items[] = 'role_id';
        $items[] = 'title';
        $items[] = 'description';
        $items[] = 'is_view_on_web';
        $items[] = 'status';
        $data = elements($items, $_POST);

        $data['date'] = $this->input->post('date') ? date('Y-m-d H:i:s', strtotime($this->input->post('date'))) : date('Y-m-d H:i:s');

        if ($this->input->post('id')) {
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();
        } else {
            $data['created_at'] = date('Y-m-d H:i:s');
            $data['created_by'] = logged_in_user_id();
        }

        if ($_FILES['attachment']['name']) {
            $data['attachment'] = $this->_upload_attachment();
        }

        return $data;
    }

    /*     * ***************Function _upload_attachment**********************************
     * @type            : Function
     * @function name   : _upload_attachment
     * @description     : Process to upload notice attachment into server
     *                     and return attachment file name
     * @param           : null
     * @return          : $return_attachment string value
     * ********************************************************** */

    private function _upload_attachment() {

        $prev_attachment = $this->input->post('prev_attachment');
        $attachment = $_FILES['attachment']['name'];
        $attachment_type = $_FILES['attachment']['type'];
        $return_attachment = '';

        if ($attachment != "") {
            if (
                $attachment_type == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ||
                $attachment_type == 'application/msword' || $attachment_type == 'text/plain' ||
                $attachment_type == 'application/vnd.ms-office' || $attachment_type == 'application/pdf' ||
                $attachment_type == 'image/jpeg' || $attachment_type == 'image/pjpeg' ||
                $attachment_type == 'image/jpg' || $attachment_type == 'image/png' ||
                $attachment_type == 'image/x-png' || $attachment_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/notice/';

                $file_type = explode(".", $attachment);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $attachment_path = 'notice-attachment-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['attachment']['tmp_name'], $destination . $attachment_path);

                // need to unlink previous attachment
                if ($prev_attachment != "") {
                    if (file_exists($destination . $prev_attachment)) {
                        @unlink($destination . $prev_attachment);
                    }
                }

                $return_attachment = $attachment_path;
            }
        } else {
            $return_attachment = $prev_attachment;
        }

        return $return_attachment;
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "Notice" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('announcement/notice');
        }

        $notice = $this->notice->get_single('notices', array('id' => $id));

        if ($this->notice->delete('notices', array('id' => $id))) {
            // delete attachment
            $destination = 'assets/uploads/';
            if (file_exists($destination . '/notice/' . $notice->attachment)) {
                @unlink($destination . '/notice/' . $notice->attachment);
            }
            create_log('Has been deleted a Notice : ' . $notice->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
