<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('accounting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('payment'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php if (isset($invoices) && !empty($invoices)) { ?>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'accounting', 'payment')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-money font-30 mr-10"></i>
                                <?php echo $this->lang->line('investigation'); ?> <?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <button title="<?php echo $this->lang->line('print'); ?>" type="button" onclick="printBill(<?php echo $payemnt_id; ?>);" class="btn btn-info btn-xs">
                                <?php echo $this->lang->line('print'); ?> 
                                <i class="fa fa-print"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                            <th><?php echo $this->lang->line('date'); ?></th>
                                            <th><?php echo $this->lang->line('patient_id'); ?></th>
                                            <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('doctor'); ?></th>
                                            <th><?php echo $this->lang->line('reference'); ?></th>
                                            <th><?php echo $this->lang->line('commission'); ?></th>
                                            <th><?php echo $this->lang->line('payment'); ?></th>
                                            <th><?php echo $this->lang->line('created_by'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        $total_commission_amount = 0;
                                        $total_payable_amount = 0;
                                        if (isset($invoices) && !empty($invoices)) { ?>
                                            <?php foreach ($invoices as $obj) {
                                                $total_commission_amount += $obj->commission_amount;
                                                $total_payable_amount += $obj->payable_amount;
                                            ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $obj->bill_invoice; ?></td>
                                                    <td><?php echo date('d/m/Y h:i A', strtotime($obj->bill_date)); ?></td>
                                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                                    <td><?php echo $obj->patient; ?></td>
                                                    <td><?php echo $obj->doctor; ?></td>
                                                    <td><?php echo $obj->reference; ?></td>
                                                    <td><?php echo $obj->commission_amount; ?></td>
                                                    <td><?php echo $obj->payable_amount; ?></td>
                                                    <td><?php echo $obj->created_by; ?></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->

<script>
    function printBill(id) {
        $.ajax({
            url: '<?php echo site_url('accounting/payment/multi_investigation_print'); ?>',
            type: 'POST',
            data: {
                id: id,
            },
            success: function(result) {
                $("#testdata").html(result);
                popup(result);
            }
        });
    }

    function popup(data) {
        var frame1 = $('<iframe />');
        frame1[0].name = "frame1";
        frame1.css({
            "position": "absolute",
            "top": "-1000000px"
        });
        $("body").append(frame1);
        var frameDoc = frame1[0].contentWindow ? frame1[0].contentWindow : frame1[0].contentDocument.document ? frame1[0].contentDocument.document : frame1[0].contentDocument;
        frameDoc.document.open();
        //Create a new HTML document.
        frameDoc.document.write('<html>');
        frameDoc.document.write('<head>');
        frameDoc.document.write('<title>Print Invoice</title>');

        frameDoc.document.write('</head>');
        frameDoc.document.write('<body>');
        frameDoc.document.write(data);
        frameDoc.document.write('</body>');
        frameDoc.document.write('</html>');
        frameDoc.document.close();
        setTimeout(function() {
            window.frames["frame1"].focus();
            window.frames["frame1"].print();
            frame1.remove();
            //window.location.reload(true);
        }, 500);

        return true;

    }
</script>