<!DOCTYPE html>
<html>

<head>
    <title>Print Bill</title>

    <style>
        body {
            font-family: monospace;
            font-size: 12px;
        }

        .page {
            width: 60%;
            margin: 0 auto;
        }

        @page {
            size: A4;
            margin: 0;
        }

        @media print {

            html,
            body {
                font-family: Arial, Helvetica, sans-serif;
            }

            .page {
                width: 60%;
                margin: 0 auto;
                border: initial;
                border-radius: initial;
                min-height: initial;
                box-shadow: initial;
                background: initial;
                /*page-break-after: always;*/
            }
        }

        .header {
            width: 100%;
            display: inline-block;
          	margin-top: 5px;
        }

        .header img {
            width: 80px;
        }

        .header h1 {
            margin: 0;
            padding: 0;
            text-transform: uppercase;
            font-size: 25px;
        }

        .header p {
            margin: 0;
            padding: 0;
        }

        .header .title {
            margin-top: 10px;
            margin-bottom: 10px;
            text-align: center;
        }

        .header .title span {
            background-color: #000;
            color: #fff;
            border: 1px solid #000;
            border-radius: 5px;
            font-family: monospace;
            font-size: 16px;
            font-weight: bold;
            padding: 5px 10px;
            text-transform: uppercase;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info {
            margin-bottom: 20px;
        }

        .info tbody td {
            color: #000;
            vertical-align: middle;
            font-weight: bold;
            padding: 3px 0;
            font-size: 12px;
        }

        .details thead th {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            width: max-content;
            font-size: 10px;
        }

        .details tbody td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }

        .details tfoot td {
            color: #000;
            padding: 1px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 10px;
        }


        .summary {
            width: 50%;
            margin: 20px auto;
            float: right;
        }

        .summary tbody td {
            color: #000;
            padding: 3px;
            vertical-align: middle;
            border: 1px solid #000;
            font-weight: bold;
            text-align: left;
            font-size: 10px;
        }
        .sign {
            width: 100%;
            margin-top: 30px;
        }
    </style>
</head>

<body>
    <div class="page">
      	<img style="margin-top: 100px;" src="<?php echo IMG_URL; ?>bill_head.png" alt="h" width="100%">
        <div class="header">
            <table class="table">
                <tbody>
                    <tr>
                        <td>
                            <div class="title" align="center">
                                <span>Investigation Payment Voucher</span>
                            </div>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
        <!-- Header End -->
        <div class="body">
            <table class="table info">
                <tbody>
                    <tr>
                        <td colspan="2">
                            Payment Invoice ID: <?php echo $patient->custom_invoice_id; ?>
                        </td>
                        <td colspan="2" align="right" style="font-weight: normal;">
                            Print Time: <?php echo date('M d, Y h:i A'); ?>
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <?php
                            if ($patient->commission_type == 'mbbs') {
                                echo 'Doctor:';
                            } elseif ($patient->commission_type == 'vd') {
                                echo 'Ref. Name:';
                            } elseif ($patient->commission_type == 'emp') {
                                echo 'Employee Name:';
                            } else {
                                echo 'Corporate:';
                            }
                            ?>
                            <?php echo $patient->reference; ?>
                        </td>
                      	<td>
                            ID: <?php echo $patient->reference_id; ?>
                        </td>
                        
                        <td align="right">
                            Payment Date: <?php echo date('M d, Y h:i A', strtotime($patient->date)); ?>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            Address: <?php echo $patient->address; ?>
                        </td>
                      	<td>
                            Mobile: <?php echo $patient->ref_phone; ?>
                        </td>
                        <td colspan="2" align="right">
                            Prepared By: <?php echo $patient->created_by; ?>
                        </td>
                    </tr>
                </tbody>
            </table>

            <!-- Datails -->
            <table class="table details">
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Bill Date</th>
                        <th>Patient Name</th>
                        <th>Total</th>
                        <th>Discount</th>
                        <th><?php echo $this->lang->line('net_payable'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo $patient->bill_invoice; ?></td>
                        <td><?php echo date('M d, Y h:ia', strtotime($patient->bill_date)); ?></td>
                        <td><?php echo $patient->patient_name; ?></td>
                        <td><?php echo number_format($patient->total_bill, 2); ?></td>
                        <td><?php echo number_format($patient->discount, 2); ?></td>
                      	<td><?php echo $patient->net_payable; ?></td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="3" align="right"><strong>Total:</strong></td>
                        <td><?php echo $patient->total_bill; ?></td>
                        <td><?php echo $patient->discount; ?></td>
                        <td><?php echo $patient->net_payable; ?></td>
                    </tr>]
                  	<tr>
                        <td colspan="5" align="right"><strong>Commission:</strong></td>
                        <td><?php echo number_format($patient->payable_amount, 2); ?></td>
                    </tr>
                </tfoot>
            </table>
            
            <table class="sign">
                <tr>
                    <td width="30%">Signature</td>
                    <td width="70%">Mobile:</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>