<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('accounting'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('expenditure'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <?php $this->load->view('accounting/left-side'); ?>
        <!-- col-xl-9 -->
        <div class="col-lg-9">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'accounting', 'expenditure')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-battery-half font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('expenditure'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'accounting', 'expenditure')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('accounting/expenditure'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('expenditure'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('accounting/expenditure/edit/' . $expenditure->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-5 mb-10">
                            <label for="expenditure_head_id"><?php echo $this->lang->line('expenditure_head'); ?></label>
                            <select class="form-control custom-select select2" name="expenditure_head_id" id="expenditure_head_id" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('expenditure_head'); ?></option>
                                <?php foreach ($expheads as $obj) { ?>
                                    <option value="<?php echo $obj->id; ?>" <?php echo isset($expenditure->expenditure_head_id) && $expenditure->expenditure_head_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->bn_name; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <!-- <div class="col-md-3 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <option value="opd" <?php echo isset($expenditure->type) && $expenditure->type == 'opd' ? 'selected="selected"' : ""; ?>>OPD</option>
                                <option value="ipd" <?php echo isset($expenditure->type) && $expenditure->type == 'ipd' ? 'selected="selected"' : ""; ?>>IPD</option>
                                <option value="other" <?php echo isset($expenditure->type) && $expenditure->type == 'other' ? 'selected="selected"' : ""; ?>>Other</option>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div> -->
                        <div class="col-md-7 mb-10">
                            <label for="name"><?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($expenditure->name) ?  $expenditure->name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="reference"><?php echo $this->lang->line('reference'); ?></label>
                            <input type="text" class="form-control" name="reference" id="reference" value="<?php echo isset($expenditure->reference) ?  $expenditure->reference : ''; ?>" placeholder="<?php echo $this->lang->line('reference'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="invoice_no"><?php echo $this->lang->line('invoice_no'); ?></label>
                            <input type="text" class="form-control" name="invoice_no" id="invoice_no" value="<?php echo isset($expenditure->invoice_no) ?  $expenditure->invoice_no : ''; ?>" placeholder="<?php echo $this->lang->line('invoice_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="payment_method"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('method'); ?></label>
                            <select class="form-control custom-select" name="payment_method" id="payment_method" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?></option>
                                <?php $payment_methods = get_payment_methods(); ?>
                                <?php foreach ($payment_methods as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($expenditure->payment_method) && $expenditure->payment_method == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="bank_name"><?php echo $this->lang->line('bank_name'); ?></label>
                            <input type="text" class="form-control" name="bank_name" id="bank_name" value="<?php echo isset($expenditure->bank_name) ?  $expenditure->bank_name : ''; ?>" placeholder="<?php echo $this->lang->line('bank_name'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="cheque_no"><?php echo $this->lang->line('cheque_no'); ?></label>
                            <input type="text" class="form-control" name="cheque_no" id="cheque_no" value="<?php echo isset($expenditure->cheque_no) ?  $expenditure->cheque_no : ''; ?>" placeholder="<?php echo $this->lang->line('cheque_no'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="amount"><?php echo $this->lang->line('amount'); ?></label>
                            <input type="text" class="form-control" name="amount" id="amount" value="<?php echo isset($expenditure->amount) ?  $expenditure->amount : ''; ?>" placeholder="<?php echo $this->lang->line('amount'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($expenditure->date) ?  $expenditure->date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>">
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="date" class="form-text text-muted">
                                <?php echo form_error('date'); ?>
                            </small>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="attachment"><?php echo $this->lang->line('attachment'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('upload'); ?></span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput"><i class="glyphicon glyphicon-file fileinput-exists"></i> <span class="fileinput-filename"></span></div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file"><span class="fileinput-new">Select file</span><span class="fileinput-exists">Change</span>
                                        <input type="file" name="attachment">
                                        <input type="hidden" name="prev_attachment" id="prev_attachment" value="<?php echo $expenditure->attachment; ?>" />
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                        </div>
                        <div class="col-md-1 mb-10">
                            <div class="avatar mt-40 ml-10">
                                <?php if ($expenditure->attachment != '') { ?>
                                    <a target="_blank" href="<?php echo UPLOAD_PATH; ?>attachment/<?php echo $expenditure->attachment; ?>"><i class="fa fa-download" aria-hidden="true"></i></a>
                                <?php } ?>
                            </div>
                        </div>
                        <div class="col-md-1 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $expenditure->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($expenditure->note) ?  $expenditure->note : ''; ?></textarea>
                                <div class="valid-feedback">
                                    <?php echo $this->lang->line('looks_good'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $expenditure->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('accounting/expenditure'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#date").daterangepicker({
        singleDatePicker: true,
        startDate: new Date(),
        showDropdowns: true,
        minYear: 1901,
        timePicker: true,
        timePicker24Hour: true,
        timePickerIncrement: 1,
        timePickerSeconds: false,
        autoUpdateInput: true,
        locale: {
            format: 'YYYY-MM-DD HH:mm',
        }
    });
</script>