<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Expenditure_Model extends MY_Model
{

    function __construct()
    {
        parent::__construct();
    }

    public function get_employee_list()
    {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, MARKETING));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }

    public function get_expenditure_list($limit, $offset, $keyword, $form_date, $to_date, $expenditure_head_id, $type, $payment_method, $created_by, $count)
    {
        $this->db->select('E.*, EH.name as expenditure_head');
        $this->db->from('expenditures AS E');
        $this->db->join('expenditure_heads AS EH', 'EH.id = E.expenditure_head_id', 'left');
        if ($keyword) {
            $this->db->like('E.custom_invoice_id', $keyword);
            $this->db->or_like('E.name', $keyword);
            $this->db->or_like('E.invoice_no', $keyword);
            $this->db->or_like('E.bank_name', $keyword);
            $this->db->or_like('E.cheque_no', $keyword);
            $this->db->or_like('EH.name', $keyword);
        }
        if ($form_date && $to_date) {
            $this->db->where("DATE(E.date) BETWEEN '$form_date' AND '$to_date'");
        }
        if ($expenditure_head_id) {
            $this->db->where('E.expenditure_head_id', $expenditure_head_id);
        }
        if ($type) {
            $this->db->where('E.type', $type);
        }
        if ($payment_method) {
            $this->db->where('E.payment_method', $payment_method);
        }
        if ($created_by) {
            $this->db->where('E.created_by', $created_by);
        }
        $this->db->order_by('E.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }


    public function get_single_expenditure($id)
    {
        $this->db->select('E.*, EH.name as expenditure_head, C.name as created_by, M.name as modified_by');
        $this->db->from('expenditures AS E');
        $this->db->join('expenditure_heads AS EH', 'EH.id = E.expenditure_head_id', 'left');
        $this->db->join('employees AS C', 'C.user_id = E.created_by', 'left');
        $this->db->join('employees AS M', 'M.user_id = E.modified_by', 'left');
        $this->db->where('E.id', $id);
        return $this->db->get()->row();
    }
}
