<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Investigation.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Investigation
 * @description     : Manage all kind of investigation commission paymnet.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Investigation extends My_Controller {

    public $data = array();
    function __construct() {
        parent::__construct();
        $this->load->model('Investigation_Model', 'investigation', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Investigation Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        if (isset($_GET) && $this->input->get('type') === 'multiple' && $this->input->get('status') === 'unpaid' && $this->input->get('reference_id') > 0) {
            $type = $this->input->get('type');
            $status = $this->input->get('status');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            if (isset($date) && !empty($date)) {
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = null;
                $to_date = null;
            }
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');
            $this->data['multi_investigations'] = $this->investigation->get_multi_investigation_invoice_list($status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword);

            $this->data['type'] = $type;
            $this->data['status'] = $status;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } elseif (isset($_GET) && $this->input->get('status')) {
            $type = $this->input->get('type');
            $status = $this->input->get('status');
            $keyword = trim($this->input->get('keyword'));
            $date = $this->input->get('date');
            if (isset($date) && !empty($date)) {
                $exp = explode('-', $date);
                $form_date = date('Y-m-d', strtotime($exp[0]));
                $to_date = date('Y-m-d', strtotime($exp[1]));
            } else {
                $form_date = null;
                $to_date = null;
            }
            $doctor_id = $this->input->get('doctor_id');
            $reference_id = $this->input->get('reference_id');
            $created_by = $this->input->get('created_by');

            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = site_url('accounting/investigation/?status=' . $status . '&date=' . $date . '&reference_id=' . $reference_id . '&doctor_id=' . $doctor_id  . '&created_by=' . $created_by . '&keyword=' . $keyword);
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->investigation->get_investigation_invoice_list($config['per_page'], $offset, $status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['investigations'] = $this->investigation->get_investigation_invoice_list($config['per_page'], $offset, $status, $form_date, $to_date, $reference_id, $doctor_id, $created_by, $keyword, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));


            $this->data['type'] = $type;
            $this->data['status'] = $status;
            $this->data['keyword'] = $keyword;
            $this->data['date'] = $date;
            $this->data['doctor_id'] = $doctor_id;
            $this->data['reference_id'] = $reference_id;
            $this->data['created_by'] = $created_by;
        } else {
            $form_date = date('Y-m-d');
            $to_date = date('Y-m-d');
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            $config['base_url'] = current_url();
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->investigation->get_investigation_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, null, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['investigations'] = $this->investigation->get_investigation_invoice_list($config['per_page'], $offset, null, $form_date, $to_date, null, null, null, null, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['type'] = 'single';
        }
		
        $this->data['doctors'] = $this->investigation->get_doctor_list();
        $this->data['references'] = $this->investigation->get_investigation_reference_list();
        $this->data['employees'] = $this->investigation->get_employee_list();

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('payment/investigation/index', $this->data);
    }

     public function get_single_investigation_payment_view() {
        $id = $this->input->post('id');
        $this->data['payment'] = $this->investigation->get_single_investigation_payment($id);
        echo $this->load->view('investigation/view', $this->data);
    }

    /*****************Function investigation_print**********************************
     * @type            : Function
     * @function name   : investigation_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function investigation_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->investigation->get_single_investigation_payment($this->input->post('id'));
        $this->data['departments'] = $this->investigation->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('investigation/print', $this->data);
    }

    /*****************Function investigation_draft_print**********************************
     * @type            : Function
     * @function name   : investigation_draft_print
     * @description     : Load "print" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function investigation_draft_print() {
        $this->load->library('Numbertowords');
        $this->data['patient'] = $this->investigation->get_single_investigation_draft_print($this->input->post('id'));
        $this->data['departments'] = $this->investigation->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('investigation/draft-print', $this->data);
    }

    public function multi_investigation_payment() {

        $this->db->trans_start();
        if (!empty($_POST['invoices'])) {
            $total_commission_amount = 0;
            $total_commission_payable_amount = 0;
            foreach ($_POST['invoices'] as $key => $value) {
                $invoice = $this->investigation->get_single('invoices', array('id' => $value));
                $total_commission_amount += $invoice->commission_amount;
                $total_commission_payable_amount += $_POST['payable_amount'][$value];
            }
            // Payment Invoice Data
            $payment_invoice = array(
                'custom_invoice_id' => get_datewise_payment_custom_invoice_id('payment_invoices', 'investigation', date('Y-m-d'), 'INV-', date('Y'), date('m'), date('d')),
                'commission_id' => $this->input->post('reference_id'),
                'invoice_type' => 'investigation',
                'date' => date('Y-m-d H:i:s'),
                'total_commission_amount' => $total_commission_amount,
                'total_payable_commission' => $total_commission_payable_amount,
                'paid_status' => 'paid',
                'payment_status' => 'complete',
                'status' => 1,
                'created_at' => date('Y-m-d H:i:s'),
                'created_by' => logged_in_user_id()
            );
            $payment_id =  $this->investigation->insert('payment_invoices', $payment_invoice);
            foreach ($_POST['invoices'] as $key => $value) {
                $invoice = $this->investigation->get_single('invoices', array('id' => $value));
                $data['custom_invoice_id'] = get_datewise_payment_custom_invoice_id('payments', 'investigation', date('Y-m-d'), 'PINV-', date('Y'), date('m'), date('d'));
                $data['patient_id'] = $invoice->patient_id;
                $data['invoice_id'] = $value;
                $data['payment_id'] = $payment_id;
                $data['invoice_type'] = 'investigation';
                $data['commission_user_id'] = $invoice->commission_user_id;
                $data['commission_amount'] = $invoice->commission_amount;


                $data['payable_amount'] = $_POST['payable_amount'][$value];
                $data['due_amount'] = 0;
                $data['paid_status'] = 'paid';
                $data['payment_status'] = 'complete';
                $data['date'] = date('Y-m-d H:i:s');
                $data['status'] = 1;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();
                $insert_id = $this->investigation->insert('payments', $data);

                // Payment Details Data
                $payment_details = array(
                    'invoice_id' => $value,
                    'payment_id' => $insert_id,
                    'amount' => $data['payable_amount'],
                    'payment_date' => date('Y-m-d H:i:s'),
                    'status' => 1,
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' => logged_in_user_id()
                );
                $this->investigation->insert('payment_details', $payment_details);

                //Invoice Table Update Data
                $this->investigation->update('invoices', array('commission_payment' => 'paid'), array('id' => $value));

                // Send SMS
                if (has_permission(ADD, 'accounting', 'investigation_payment_sms')) {
                    send_sms('investigation_payment_sms', $insert_id);
                }

                $commission = $this->investigation->get_single('employees', array('user_id' => $data['commission_user_id']));
                create_log('Has been created a multiple investigation commission payment for invoice : ' . $data['custom_invoice_id'] . ' commission name: ' . $commission->name);
            }
        }
        $this->db->trans_complete();
        if ($insert_id) {
            success($this->lang->line('insert_success'));
            redirect('accounting/investigation_success/' . $payment_id);
        } else {
            error($this->lang->line('insert_failed'));
            redirect('accounting/investigation');
        }
    }

    public function investigation_success($id) {
        $this->data['invoices'] = $this->investigation->get_multi_investigation_payment_invoice($id);
        $this->data['payemnt_id'] = $id;
        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('investigation') . ' ' . $this->lang->line('payment') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('investigation/success', $this->data);
    }

    public function multi_investigation_print() {
        $id = $this->input->post('id');
        $this->load->library('Numbertowords');
        $this->data['reference'] = $this->investigation->get_multi_patient_reference($id);
        $this->data['invoices'] = $this->investigation->get_multi_investigation_payment_invoice($id);
        $this->data['departments'] = $this->investigation->get_list('diagnostic_departments', array('status' => 1), '', '', '', 'sort_by', 'ASC');
        $this->load->view('investigation/multi-print', $this->data);
    }

    public function investigation_payment_sms($id = null) {
        check_permission(VIEW);
        if ($id) {
            send_sms('investigation_payment_sms', $id);
        }
    }
}
