<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Incomehead.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Incomehead
 * @description     : Manage all incomehead type/head/title as per accounting rule.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : https://hms.sbitzone.com/      
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Incomehead extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Incomehead_Model', 'incomehead', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "Income Head Listing" user interface                 
     *                        
     * @param           : null
     * @return          : null 
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('accounting/incomehead/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->incomehead->get_incomehead_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['incomeheads'] = $this->incomehead->get_incomehead_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('income_head') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('income_head/index', $this->data);
    }

    /*****************Function add**********************************
     * @type            : Function
     * @function name   : add
     * @description     : Load "Add new income head" user interface
     *                    and process to store "income_heads" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->incomehead->insert('income_heads', $data);
                if ($insert_id) {
                    create_log('Has been created a income head : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('accounting/incomehead');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('accounting/incomehead/add');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('income_head') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('accounting/income_head/add', $this->data);
    }

    /*****************Function edit**********************************
     * @type            : Function
     * @function name   : edit
     * @description     : Load "Edit new income head" user interface
     *                    and process to store "income_heads" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_name');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->incomehead->update('income_heads', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a income head : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('accounting/incomehead');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('accounting/incomehead/edit/' . $this->input->post('id'));
                }
            } else {
                $this->data['incomehead'] = $this->incomehead->get_single('income_heads', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['incomehead'] = $this->incomehead->get_single('income_heads', array('id' => $id));
                if (!$this->data['incomehead']) {
                    redirect('accounting/incomehead');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('income_head') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('accounting/income_head/edit', $this->data);
    }

    /*****************Function name**********************************
     * @type            : Function
     * @function name   : name
     * @description     : Unique check for "Income Head Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function name() {
        if ($this->input->post('id') == '') {
            $name = $this->incomehead->duplicate_check($this->input->post('name'));
            if ($name) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $name = $this->incomehead->duplicate_check($this->input->post('name'), $this->input->post('id'));
            if ($name) {
                $this->form_validation->set_message('name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete**********************************
     * @type            : Function
     * @function name   : delete
     * @description     : delete "income_heads" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('accounting/incomehead');
        }

        $incomehead = $this->incomehead->get_single('income_heads', array('id' => $id));

        if ($this->incomehead->delete('income_heads', array('id' => $id))) {
            create_log('Has been deleted a income head : ' . $incomehead->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
