<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * ***************Profile.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Profile
 * @description     : This class used to manage logged in users 
 *                    profile information of the application.  
 * @author          : South Bangla IT Zone Team 	
 * @url             : http://hms.sbitzone.com    
 * @support         : rabibd.it@gmail.com	
 * @copyright       : South Bangla IT Zone Team	 	
 * ********************************************************** */

class Profile extends My_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Profile_Model', 'profile', true);
        //$this->global_setting = $this->db->get_where('global_setting', array('status' => 1))->row();
    }

    /**     * *************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : this function used to load logged in user profile information
     * @param           : null;
     * @return          : null
     * ********************************************************** */
    public function index() {

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['phone'] = $this->input->post('phone');
                $data['national_id'] = $this->input->post('national_id');
                $data['gender'] = $this->input->post('gender');
                $data['religion'] = $this->input->post('religion');
                $data['blood_group'] = $this->input->post('blood_group');
                $data['marital_status'] = $this->input->post('marital_status');
                $data['present_address'] = $this->input->post('present_address');
                $data['permanent_address'] = $this->input->post('permanent_address');
                $data['father_name'] = $this->input->post('father_name');
                $data['father_bn_name'] = $this->input->post('father_bn_name');
                $data['mother_name'] = $this->input->post('mother_name');
                $data['mother_bn_name'] = $this->input->post('mother_bn_name');
                $data['email'] = $this->input->post('email');
                $data['about'] = $this->input->post('about');

                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $this->profile->update('employees', $data, array('user_id' => logged_in_user_id()));
                
                success($this->lang->line('update_success'));
                create_log('Update Profile Info');
            }
        }

        $this->layout->title($this->lang->line('my_profile') . ' | ' . $this->global_setting->brand_title);
        $this->data['profile_info'] = true;
        $role_id = $this->session->userdata('role_id');
        $user_id = $this->session->userdata('user_id');
        $this->data['profile'] = get_user_by_role($role_id, $user_id);

        if ($role_id == SUPER_ADMIN) {
            $this->layout->view('profile/employee', $this->data);
        } else {
            $this->layout->view('profile/employee', $this->data);
        }
    }

    /*     * *************Function photo**********************************
     * @type            : Function
     * @function name   : photo
     * @description     : this function used to photo update logged user profile inormation            
     * @param           : null; 
     * @return          : null 
     * ********************************************************** */

    public function photo() {

        if ($_POST) {
            if ($_FILES['photo']['name']) {
                $data['photo'] = $this->_upload_photo();
            }
            if ($_FILES['cover']['name']) {
                $data['cover'] = $this->_upload_cover();
            }
            if ($_FILES['signature']['name']) {
                $data['signature'] = $this->_upload_signature();
            }
            if ($_FILES['resume']['name']) {
                $data['resume'] = $this->_upload_resume();
            }

            // common data
            $data['modified_at'] = date('Y-m-d H:i:s');
            $data['modified_by'] = logged_in_user_id();

            $this->profile->update('employees', $data, array('user_id' => logged_in_user_id()));
            success($this->lang->line('update_success'));
            create_log('Update Photos Info');
        }

        $this->layout->title($this->lang->line('my_profile') . ' | ' . $this->global_setting->brand_title);
        $this->data['photo_info'] = true;
        $role_id = $this->session->userdata('role_id');
        $user_id = $this->session->userdata('user_id');
        $this->data['profile'] = get_user_by_role($role_id, $user_id);

        if ($role_id == SUPER_ADMIN) {
            $this->layout->view('profile/photo', $this->data);
        } else {
            $this->layout->view('profile/photo', $this->data);
        }
    }

    /*     * *************Function social**********************************
     * @type            : Function
     * @function name   : social
     * @description     : this function used to social update logged user profile inormation            
     * @param           : null; 
     * @return          : null 
     * ********************************************************** */

    public function social() {
        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('facebook_url', $this->lang->line('facebook_url'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['facebook_url'] = $this->input->post('facebook_url');
                $data['linkedin_url'] = $this->input->post('linkedin_url');
                $data['twitter_url'] = $this->input->post('twitter_url');
                $data['instagram_url'] = $this->input->post('instagram_url');
                $data['pinterest_url'] = $this->input->post('pinterest_url');
                $data['youtube_url'] = $this->input->post('youtube_url');
                $data['tubblr_url'] = $this->input->post('tubblr_url');
                $data['skype'] = $this->input->post('skype');

                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $this->profile->update('employees', $data, array('user_id' => logged_in_user_id()));
                success($this->lang->line('update_success'));
                create_log('Update Social Info');
            }
        }

        $this->layout->title($this->lang->line('my_profile') . ' | ' . $this->global_setting->brand_title);
        $this->data['social_info'] = true;
        $role_id = $this->session->userdata('role_id');
        $user_id = $this->session->userdata('user_id');
        $this->data['profile'] = get_user_by_role($role_id, $user_id);

        if ($role_id == SUPER_ADMIN) {
            $this->layout->view('profile/social', $this->data);
        } else {
            $this->layout->view('profile/social', $this->data);
        }
    }

    /**     * *************Function password**********************************
     * @type            : Function
     * @function name   : password
     * @description     : this function used to reset logged user password
     * @param           : null;
     * @return          : null
     * ********************************************************** */
    public function password() {

        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('password', $this->lang->line('password'), 'trim|required|min_length[5]|max_length[12]');
            $this->form_validation->set_rules('conf_password', $this->lang->line('conf_password'), 'trim|required|matches[password]');

            if ($this->form_validation->run() === TRUE) {
                $data['password'] = md5($this->input->post('password'));
                $data['temp_password'] = base64_encode($this->input->post('password'));
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                $this->profile->update('users', $data, array('id' => logged_in_user_id()));

                success($this->lang->line('update_success'));
                $this->profile->get_single('users', array('id' => logged_in_user_id()));
                create_log('Update Password');
            }
        }

        $role_id = $this->session->userdata('role_id');
        $user_id = $this->session->userdata('user_id');
        $this->data['profile'] = get_user_by_role($role_id, $user_id);

        $this->data['password_info'] = true;
        $this->layout->title($this->lang->line('reset_password') . ' | ' . TITLE);
        $this->layout->view('profile/password', $this->data);
    }

    /**     * *************Function _upload_photo**********************************
     * @type            : Function
     * @function name   : _upload_photo
     * @description     : this private function used to upload user profile photo
     * @param           : null;
     * @return          : null
     * ********************************************************** */
    private function _upload_photo() {

        $prev_photo = $this->input->post('prev_photo');

        $user_type = 'employee';
        $photo = $_FILES['photo']['name'];
        $photo_type = $_FILES['photo']['type'];
        $return_photo = '';
        if ($photo != "") {
            if (
                $photo_type == 'image/jpeg' || $photo_type == 'image/pjpeg' ||
                $photo_type == 'image/jpg' || $photo_type == 'image/png' ||
                $photo_type == 'image/x-png' || $photo_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/' . $user_type . '-photo/';

                $file_type = explode(".", $photo);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $photo_path = 'photo-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['photo']['tmp_name'], $destination . $photo_path);

                // need to unlink previous photo
                if ($prev_photo != "") {
                    if (file_exists($destination . $prev_photo)) {
                        @unlink($destination . $prev_photo);
                    }
                }

                $return_photo = $photo_path;
            }
        } else {
            $return_photo = $prev_photo;
        }

        return $return_photo;
    }

    /**     * *************Function _upload_cover**********************************
     * @type            : Function
     * @function name   : _upload_cover
     * @description     : this private function used to upload user profile cover
     * @param           : null;
     * @return          : null
     * ********************************************************** */
    private function _upload_cover() {

        $prev_cover = $this->input->post('prev_cover');

        $user_type = 'employee';
        $cover = $_FILES['cover']['name'];
        $cover_type = $_FILES['cover']['type'];
        $return_cover = '';
        if ($cover != "") {
            if (
                $cover_type == 'image/jpeg' || $cover_type == 'image/pjpeg' ||
                $cover_type == 'image/jpg' || $cover_type == 'image/png' ||
                $cover_type == 'image/x-png' || $cover_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/' . $user_type . '-cover/';

                $file_type = explode(".", $cover);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $cover_path = 'cover-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['cover']['tmp_name'], $destination . $cover_path);

                // need to unlink previous cover
                if ($prev_cover != "") {
                    if (file_exists($destination . $prev_cover)) {
                        @unlink($destination . $prev_cover);
                    }
                }

                $return_cover = $cover_path;
            }
        } else {
            $return_cover = $prev_cover;
        }

        return $return_cover;
    }

    /*     * ***************Function _upload_signature**********************************
     * @type            : Function
     * @function name   : _upload_signature
     * @description     : process to upload employee signature in the server
     *                     and return signature file name
     * @param           : null
     * @return          : $return_signature string value
     * ********************************************************** */

    private function _upload_signature() {
        $user_type = 'employee';
        $prev_signature = $this->input->post('prev_signature');
        $signature = $_FILES['signature']['name'];
        $signature_type = $_FILES['signature']['type'];
        $return_signature = '';
        if ($signature != "") {
            if (
                $signature_type == 'image/jpeg' || $signature_type == 'image/pjpeg' ||
                $signature_type == 'image/jpg' || $signature_type == 'image/png' ||
                $signature_type == 'image/x-png' || $signature_type == 'image/gif'
            ) {

                $destination = 'assets/uploads/' . $user_type . '-signature/';
                $file_type = explode(".", $signature);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $signature_path = 'signature-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['signature']['tmp_name'], $destination . $signature_path);

                // need to unlink previous signature
                if ($prev_signature != "") {
                    if (file_exists($destination . $prev_signature)) {
                        @unlink($destination . $prev_signature);
                    }
                }

                $return_signature = $signature_path;
            }
        } else {
            $return_signature = $prev_signature;
        }

        return $return_signature;
    }

    /*     * **************Function _upload_resume**********************************
     * @type            : Function
     * @function name   : _upload_resume
     * @description     : this private function used to upload user profile resume
     * @param           : null;
     * @return          : null
     * ********************************************************** */

    private function _upload_resume() {
        $user_type = 'employee';
        $prev_resume = $this->input->post('prev_resume');
        $resume = $_FILES['resume']['name'];
        $resume_type = $_FILES['resume']['type'];
        $return_resume = '';

        if ($resume != "") {
            if (
                $resume_type == 'application/vnd.openxmlformats-officedocument.wordprocessingml.document' ||
                $resume_type == 'application/msword' || $resume_type == 'text/plain' ||
                $resume_type == 'application/vnd.ms-office' || $resume_type == 'application/pdf'
            ) {

                $destination = 'assets/uploads/' . $user_type . '-resume/';

                $file_type = explode(".", $resume);
                $extension = strtolower($file_type[count($file_type) - 1]);
                $resume_path = 'resume-' . time() . '-sbiz.' . $extension;

                move_uploaded_file($_FILES['resume']['tmp_name'], $destination . $resume_path);

                // need to unlink previous photo
                if ($prev_resume != "") {
                    if (file_exists($destination . $prev_resume)) {
                        @unlink($destination . $prev_resume);
                    }
                }

                $return_resume = $resume_path;
            }
        } else {
            $return_resume = $prev_resume;
        }

        return $return_resume;
    }
}
