<!-- Home Design Inner Pages -->
<div class="ulockd-inner-home">
    <div class="container">
        <div class="row">
            <div class="inner-conraimer-details">
                <div class="col-md-12">
                    <h1 class="text-uppercase"><?php echo $this->lang->line('appointment'); ?></h1>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Home Design Inner Pages -->
<div class="ulockd-inner-page">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="ulockd-icd-layer">
                    <ul class="list-inline ulockd-icd-sub-menu">
                        <li><a href="<?php echo site_url(); ?>"> <?php echo $this->lang->line('home'); ?> </a></li>
                        <li>></li>
                        <li><?php echo $this->lang->line('appointment'); ?></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Inner Pages Main Section -->

<!-- Appointment -->
<section class="ulockd-about-one inner">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-md-offset-3 text-center">
                <div class="ulockd-main-title">
                    <h2 class="mt-separator"><?php echo $this->lang->line('appointment'); ?></h2>
                    <?php if ($this->session->userdata('site_lang') == 'bengali') { ?>
                        <p class="text-justify"><?php echo isset($this->sections->bn_appointment) && !empty($this->sections->bn_appointment) ? $this->sections->bn_appointment : ''; ?></p>
                    <?php } else { ?>
                        <p class="text-justify"><?php echo isset($this->sections->appointment) && !empty($this->sections->appointment) ? $this->sections->appointment : ''; ?></p>
                    <?php } ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 col-md-5 hidden-xs">
                <div class="about-box text-center">
                    <img class="img-responsive img-whp" src="<?php echo IMG_URL; ?>appointment.png" alt="appointment">
                </div>
            </div>
            <div class="col-md-12 col-md-7 col-sm-12">
                <!-- Search Patient -->
                <div class="appointment_form">
                    <div class="input-group">
                        <input type="number" min="0" class="form-control" name="patient_id" id="patient_id" value="<?php echo isset($patient_id) ?  $patient_id : ''; ?>" placeholder="<?php echo $this->lang->line('patient_id'); ?>" required autocomplete="off">
                        <span class="input-group-btn">
                            <button id="search" style="padding: 7px;" type="submit" class="btn btn-lg hvr-shutter-out-horizontal ulockd-btn-thm2" height="24"><?php echo $this->lang->line('search'); ?></span>
                        </span>
                    </div>
                </div>
                <!-- Appointment Form Starts -->
                <form class="appointment_form text-center" action="<?php echo site_url('appointment'); ?>" method="post">
                    <div class="row">
                        <div class="col-md-5">
                            <div class="form-group text-left">
                                <label for="department_id"><i class="fa fa-hospital-o"></i> <?php echo $this->lang->line('department'); ?></label>
                                <select class="form-control" id="department_id" name="department_id" onchange="get_doctor(this.value)">
                                    <option value="0" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('department'); ?></option>
                                    <?php foreach ($departments as $obj) { ?>
                                        <option value="<?php echo $obj->id; ?>" <?php echo isset($department_id) && $department_id == $obj->id ? 'selected="selected"' : ""; ?>><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></option>
                                    <?php } ?>
                                </select>
                                <div class="help-block with-errors"><?php echo form_error('department_id'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="form-group text-left">
                                <label for="doctor_id"><i class="fa fa-user-md"></i> <?php echo $this->lang->line('doctor'); ?> <small>*</small></label>
                                <select class="form-control select2" id="doctor_id" name="doctor_id" required>
                                    <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                    <?php foreach ($doctors as $obj) { ?>
                                        <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $this->session->userdata('site_lang') == 'bengali' ? $obj->bn_name : $obj->name; ?></option>
                                    <?php } ?>
                                </select>
                                <div class="help-block with-errors"><?php echo form_error('doctor_id'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group text-left">
                                <label for="date"><i class="fa fa-calendar-check-o"></i> <?php echo $this->lang->line('date'); ?> <small>*</small></label>
                                <input type="text" class="form-control" name="date" id="date" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required autocomplete="off">
                                <div class="help-block with-errors"><?php echo form_error('date'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group text-left">
                                <label for="name"><i class="fa fa-user"></i> <?php echo $this->lang->line('name'); ?> <small>*</small></label>
                                <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($name) ?  $name : ''; ?>" placeholder="<?php echo $this->lang->line('name'); ?>" required autocomplete="off">
                                <div class="help-block with-errors"><?php echo form_error('name'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group text-left">
                                <label for="gender"><i class="fa fa-mars-double"></i> <?php echo $this->lang->line('gender'); ?> <small>*</small></label>
                                <select class="form-control" id="gender" name="gender" required>
                                    <option value="" selected><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('gender'); ?></option>
                                    <?php $genders = get_genders(); ?>
                                    <?php foreach ($genders as $key => $value) { ?>
                                        <option value="<?php echo $key; ?>" <?php echo isset($gender) && $gender == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                    <?php } ?>
                                </select>
                                <div class="help-block with-errors"><?php echo form_error('gender'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group text-left">
                                <label for="phone"><i class="fa fa-phone"></i> <?php echo $this->lang->line('phone'); ?> <small>*</small></label>
                                <input type="number" min="0" maxlength="11" class="form-control" name="phone" id="phone" value="<?php echo isset($phone) ?  $phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>" required autocomplete="off">
                                <div class="help-block with-errors"><?php echo form_error('phone'); ?></div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group text-left">
                                <label for="address"><i class="fa fa-map-marker"></i> <?php echo $this->lang->line('address'); ?> <small>*</small></label>
                                <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($address) ?  $address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>" required autocomplete="off">
                                <div class="help-block with-errors"><?php echo form_error('address'); ?></div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group text-left">
                        <label for="note"><i class="fa fa-comment-o"></i> <?php echo $this->lang->line('remark'); ?></label>
                        <textarea class="form-control required" rows="5" id="note" name="note" placeholder="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($note) ?  $note : ''; ?></textarea>
                        <div class="help-block with-errors"><?php echo form_error('note'); ?></div>
                    </div>
                    <div class="form-group text-center">
                        <input type="hidden" id="user_id" name="user_id">
                        <input type="hidden" id="role_id" name="role_id" value="<?php echo PATIENT; ?>">
                        <button type="submit" class="btn btn-lg ulockd-btn-thm2"><?php echo $this->lang->line('submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>

<script>
    $(".select2").select2();
    $("#date").daterangepicker({
        singleDatePicker: true,
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD'
        }
    });
</script>
<script>
    function get_doctor(department_id) {
        $.ajax({
            type: "POST",
            url: "<?php echo site_url('appointment_doctor'); ?>",
            data: {
                department_id: department_id
            },
            success: function(response) {
                if (response) {
                    $('#doctor_id').html(response);
                }
            }
        });
    };
</script>
<script>
    $("#search").on("click", function() {
        var patient_id = $("#patient_id").val();
        $.ajax({
            url: '<?php echo site_url('search_patient/') ?>' + patient_id,
            dataType: 'json',
            success: function(response) {
                if (response) {
                    $('#user_id').val(response.user_id);
                    $('#name').val(response.name);
                    $('#gender').val(response.gender).trigger("change");
                    $('#phone').val(response.phone);
                    $('#address').val(response.address);
                    $.toast({
                        text: "Patient Found: " + response.name,
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-success',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                } else {
                    $.toast({
                        text: "Patient Not Found!",
                        position: 'top-right',
                        loaderBg: '#7a5449',
                        class: 'jq-toast-danger',
                        hideAfter: 3500,
                        stack: 6,
                        showHideTransition: 'fade'
                    });
                }
            }
        });
    });
</script>