<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="d-flex">
            <?php if (has_permission(VIEW, 'report', 'opd')) { ?>
                <a href="<?php echo site_url('report/opd'); ?>" class="btn btn-primary btn-sm mr-15"><?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
            <?php if (has_permission(VIEW, 'report', 'billing')) { ?>
                <a href="<?php echo site_url('report/billing'); ?>" class="btn btn-success btn-sm mr-15"><?php echo $this->lang->line('billing'); ?> <?php echo $this->lang->line('report'); ?></a>
            <?php } ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/schedule'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type" required>
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('bangla'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('english'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="slot"><?php echo $this->lang->line('slot'); ?></label>
                            <select class="form-control custom-select" name="slot" id="slot">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('slot'); ?></option>
                                <?php $slots = get_schedule_slot(); ?>
                                <?php foreach ($slots as $key => $value) { ?>
                                    <option value="<?php echo $key; ?>" <?php echo isset($slot) && $slot == $key ? 'selected="selected"' : ""; ?>><?php echo $value; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" required>
                        </div>
                        <div class="col-md-1 mb-10">
                            <label for="status"><?php echo $this->lang->line('status'); ?></label>
                            <select class="form-control custom-select" name="status" id="status">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('status'); ?></option>
                                <option value="1" <?php echo isset($status) && $status == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('in_active'); ?></option>
                                <option value="2" <?php echo isset($status) && $status == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('active'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="doctor_id"><?php echo $this->lang->line('doctor'); ?></label>
                            <select class="form-control custom-select select2" name="doctor_id" id="doctor_id">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('doctor'); ?></option>
                                <?php foreach ($doctors as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($doctor_id) && $doctor_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if (isset($schedules) && !empty($schedules)) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'schedule')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-user font-30 mr-10"></i>
                                <?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('schedule'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/schedule/pdf?type=' . $type . '&slot=' . $slot . '&date=' . $date . '&status=' . $status . '&doctor_id=' . $doctor_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead>
                                        <tr>
                                            <th width="4%"><?php echo $this->lang->line('sl_no'); ?></th>
                                            <th width="20%"><?php echo $this->lang->line('doctor'); ?> <?php echo $this->lang->line('name'); ?></th>
                                            <th width="10%"><?php echo $this->lang->line('date'); ?></th>
                                            <?php if ($slot) { ?>
                                                <th><?php echo $this->lang->line($slot); ?></th>
                                            <?php } else { ?>
                                                <?php foreach ($slots as $key => $value) { ?>
                                                    <th width="14%"><?php echo $this->lang->line($key); ?></th>
                                                <?php } ?>
                                            <?php } ?>
                                            <th width="10%"><?php echo $this->lang->line('remark'); ?></th>
                                            <th width="10%"><?php echo $this->lang->line('signature'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $count = 1;
                                        if (isset($schedules) && !empty($schedules)) { ?>
                                            <?php foreach ($schedules as $obj) { ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo $type == '1' ? $obj->doctor_bn : $obj->doctor; ?></td>
                                                    <td>
                                                        <?php if ($type == '1') {
                                                            echo $obj->date ? en2bn(date('d-m-Y', strtotime($obj->date))) : '';
                                                        } else {
                                                            echo $obj->date ? date('d-m-Y', strtotime($obj->date)) : '';
                                                        }
                                                        ?>
                                                        <br>
                                                        <?php if ($type == '1') {
                                                            echo $obj->date ? en2bnWeek(strtolower(date('l', strtotime($obj->date)))) : '';
                                                        } else {
                                                            echo $obj->date ? date('l', strtotime($obj->date)) : '';
                                                        } ?>
                                                    </td>
                                                    <?php if ($slot) { ?>
                                                        <td>
                                                            <?php echo isset($obj->start_time) && !empty($obj->start_time) ? date('h:ia', strtotime($obj->start_time)) : ''; ?>
                                                            <?php echo isset($obj->end_time) && !empty($obj->end_time) ? ' - ' . date('h:ia', strtotime($obj->end_time)) : ''; ?>
                                                        </td>
                                                    <?php } else { ?>
                                                        <?php foreach ($slots as $key => $value) {
                                                            $time = $this->schedule->get_single('doctor_schedules', array('slot' => $key, 'doctor_id' => $doctor_id ? $doctor_id : $obj->doctor_id, 'date' => $doctor_id ? $obj->date : $form_date, 'status' => 1));
                                                        ?>
                                                            <td>
                                                                <?php if ($time) { ?>
                                                                    <?php if ($type == 1) { ?>
                                                                        <?php echo isset($time->start_time) && !empty($time->start_time) ? en2bn(date('h:ia', strtotime($time->start_time))) : ''; ?>
                                                                        <?php echo isset($time->end_time) && !empty($time->end_time) ? ' - ' . en2bn(date('h:ia', strtotime($time->end_time))) : ''; ?>
                                                                    <?php } else { ?>
                                                                        <?php echo isset($time->start_time) && !empty($time->start_time) ? date('h:ia', strtotime($time->start_time)) : ''; ?>
                                                                        <?php echo isset($time->end_time) && !empty($time->end_time) ? ' - ' . date('h:ia', strtotime($time->end_time)) : ''; ?>
                                                                    <?php }  ?>
                                                                <?php } else { ?>
                                                                    --
                                                                <?php } ?>
                                                            </td>
                                                        <?php } ?>
                                                    <?php } ?>
                                                    <td><?php echo $obj->remark; ?></td>
                                                    <td></td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });
</script>