<!DOCTYPE html>
<html>

<head>
    <title>Payment</title>
    <style>
        body {
            font-family: monospace;
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
            width: fit-content;
        }

        .table_content tfoot th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .total {
            margin-top: 20px;
        }

        .total_table tbody td {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }

        .text-right {
            text-align: right;
        }

        .font-weight-600 {
            font-weight: 600;
        }

        .summary {
            margin: 30px auto 0 auto;
        }

        .summary tbody th {
            padding: 2px 2px;
            vertical-align: middle;
            border: 2px solid #000;
            font-size: 13px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->

            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="80%" align="left">
                                <?php if ($this->input->get('reference_id')) { ?>
                                    <b>Reference:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;">
                                        <?php echo $reference->commission; ?>, <?php echo $reference->designation; ?>
                                    </span>
                                <?php } else { ?>
                                    <b>All</b>
                                <?php } ?>
                            </td>
                            <td width="20%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <style>
                    .table_content th {
                        padding: 0px 3px;
                    }
                </style>
                <table class="table table_content">
                    <thead>
                        <?php if ($invoice_type == 'all') { ?>
                            <tr>
                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                <th><?php echo $this->lang->line('invoice_no'); ?></th>
                                <th><?php echo $this->lang->line('type'); ?></th>
                                <th><?php echo $this->lang->line('patient_id'); ?></th>
                                <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('payment_to'); ?></th>
                                <th><?php echo $this->lang->line('amount'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?></th>
                                <th><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                <th><?php echo $this->lang->line('created_by'); ?></th>
                            </tr>
                        <?php } else { ?>
                            <tr>
                                <th><?php echo $this->lang->line('sl_no'); ?></th>
                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                    <th width="12%"><?php echo $this->lang->line('invoice_no'); ?></th>
                                <?php } ?>
                                <th width="12%"><?php echo $this->lang->line('date'); ?></th>
                                <th width="8%"><?php echo $this->lang->line('patient_id'); ?></th>
                                <th width="15%"><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                                <th>P.<?php echo $this->lang->line('mobile'); ?></th>
                                <?php if ($invoice_type != 'assistant') { ?>
                                    <th width="15%"><?php echo $this->lang->line('doctor'); ?></th>
                                <?php } else { ?>
                                    <th width="15%"><?php echo $this->lang->line('assistant'); ?></th>
                                <?php } ?>
                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                    <th width="15%"><?php echo $this->lang->line('reference'); ?></th>
                                <?php } ?>
                              	<?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                    <th>D.<?php echo $this->lang->line('mobile'); ?></th>
                                <?php } ?>
                                <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                    <th width="10%"><?php echo $this->lang->line('commission'); ?></th>
                                <?php } else { ?>
                                    <th width="10%"><?php echo $this->lang->line('charge'); ?></th>
                                <?php } ?>
                                <th width="10%"><?php echo $this->lang->line('payment'); ?></th>
                                <th width="13%"><?php echo $this->lang->line('payment'); ?> <?php echo $this->lang->line('date'); ?></th>
                                <th width="15%"><?php echo $this->lang->line('created_by'); ?></th>
                            </tr>
                        <?php } ?>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_commission = 0;
                        $total_payment = 0;
                        foreach ($payments as $obj) {
                            $total_commission +=  $obj->commission_amount;
                            $total_payment +=  $obj->payable_amount;
                        ?>
                            <?php if ($invoice_type == 'all') { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->custom_invoice_id; ?></td>
                                    <td><?php echo $this->lang->line($obj->invoice_type); ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td>
                                        <?php if ($obj->doctor) {
                                            echo $obj->doctor;
                                        } elseif ($obj->anesthetist) {
                                            echo $obj->anesthetist;
                                        } else {
                                            echo $obj->assistant;
                                        }
                                        ?>
                                    </td>
                                    <td><?php echo $obj->commission_amount; ?></td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                        <td> <?php echo $obj->custom_invoice_id; ?></td>
                                    <?php } ?>
                                    <td><?php echo  date('M d, Y h:iA', strtotime($obj->bill_date)); ?></td>
                                    <td><?php echo $obj->patient_unique_id; ?></td>
                                    <td><?php echo $obj->patient; ?></td>
                                    <td><?php echo $obj->p_phone; ?></td>
                                    <td><?php echo $obj->doctor; ?></td>
                                    <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                        <td><?php echo $obj->reference; ?></td>
                                    <?php } ?>
                                  	<?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                        <td><?php echo $obj->reference_phone; ?></td>
                                    <?php } ?>
                                    <td><?php echo $obj->commission_amount; ?></td>
                                    <td><?php echo $obj->payable_amount; ?></td>
                                    <td><?php echo date('M d, Y h:iA', strtotime($obj->date)); ?></td>
                                    <td><?php echo $obj->created_by; ?></td>
                                </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>

                <!-- Total -->
                <table class="table summary" style="width: 50%;">
                    <?php if ($invoice_type == 'all') { ?>
                        <tbody>
                            <tr>
                                <th class="text-right text-light border-top-0">Total Amount</th>
                                <th class="text-right border-top-0"><?php echo number_format($total_commission, 2); ?></th>
                            </tr>
                            <tr>
                                <th class="text-right text-light border-top-0">Total Payment</th>
                                <th class="text-right border-top-0"><?php echo number_format($total_payment, 2); ?></th>
                            </tr>
                            <tr>
                                <th class="text-right font-weight-600">Total Payable Amount</th>
                                <th class="text-right font-weight-600"><?php echo number_format($total_payment, 2); ?></th>
                            </tr>
                        </tbody>
                    <?php } else { ?>
                        <tbody>
                            <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                <tr>
                                    <th class="text-right text-light border-top-0">Total Commission</th>
                                    <th class="text-right border-top-0"><?php echo number_format($total_commission, 2); ?></th>
                                </tr>
                                <tr>
                                    <th class="text-right text-light border-top-0">Total Payment</th>
                                    <th class="text-right border-top-0"><?php echo number_format($total_payment, 2); ?></th>
                                </tr>
                            <?php } else { ?>
                                <tr class="bg-transparent">
                                    <th class="text-right text-light border-top-0">Total Charge</th>
                                    <th class="text-right border-top-0"><?php echo number_format($total_commission, 2); ?></th>
                                </tr>
                                <tr class="bg-transparent">
                                    <th class="text-right text-light border-top-0">Total Payment</th>
                                    <th class="text-right border-top-0"><?php echo number_format($total_payment, 2); ?></th>
                                </tr>
                            <?php } ?>

                            <?php if ($invoice_type != 'surgeon' && $invoice_type != 'anesthesia' && $invoice_type != 'assistant' && $invoice_type != 'consultant') { ?>
                                <tr>
                                    <th class="text-right font-weight-600">Total Payable Amount</th>
                                    <th class="text-right font-weight-600"><?php echo number_format($total_payment, 2); ?></th>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <th class="text-right font-weight-600">Total Payable Amount</th>
                                    <th class="text-right font-weight-600"><?php echo number_format($total_payment, 2); ?></th>
                                </tr>
                            <?php } ?>
                        </tbody>
                    <?php } ?>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>