<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('report'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container-fluid">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('credit'); ?> <?php echo $this->lang->line('report'); ?>
        </h4>
        <div class="align-items-center">
            <?php echo $this->load->view('header'); ?>
        </div>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-lg-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <?php echo form_open_multipart(site_url('report/mis/credit'), array('name' => 'search', 'id' => 'search', 'method' => 'get'), ''); ?>
                    <div class="form-row">
                        <div class="col-md-2 mb-10">
                            <label for="type"><?php echo $this->lang->line('type'); ?></label>
                            <select class="form-control custom-select" name="type" id="type">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('type'); ?></option>
                                <option value="1" <?php echo isset($type) && $type == 1 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('paid'); ?></option>
                                <option value="2" <?php echo isset($type) && $type == 2 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('unpaid'); ?></option>
                                <option value="3" <?php echo isset($type) && $type == 3 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('no_reference'); ?></option>
                                <option value="4" <?php echo isset($type) && $type == 4 ? 'selected="selected"' : ""; ?>><?php echo $this->lang->line('reference'); ?></option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="date"><?php echo $this->lang->line('date'); ?></label>
                            <input type="text" class="form-control" name="date" id="range" value="<?php echo isset($date) ?  $date : ''; ?>" placeholder="<?php echo $this->lang->line('date'); ?>" autocomplete="off">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="reference_id"><?php echo $this->lang->line('reference'); ?></label>
                            <select class="form-control custom-select select2" name="reference_id" id="reference_id">
                                <option selected value="0"><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('reference'); ?></option>
                                <?php foreach ($references as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($reference_id) && $reference_id == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="created_by"><?php echo $this->lang->line('created_by'); ?></label>
                            <select class="form-control custom-select select2" name="created_by" id="created_by">
                                <option selected value=""><?php echo $this->lang->line('select'); ?> <?php echo $this->lang->line('employee'); ?></option>
                                <?php foreach ($employees as $obj) { ?>
                                    <option value="<?php echo $obj->user_id; ?>" <?php echo isset($created_by) && $created_by == $obj->user_id ? 'selected="selected"' : ""; ?>><?php echo $obj->name; ?> [<?php echo $obj->phone; ?>]</option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <button class="btn btn-gradient-primary mt-35" type="submit"><?php echo $this->lang->line('search'); ?></button>
                        </div>
                    </div>
                    <?php echo form_close(); ?>
                </div>
            </div>
        </div>

        <?php if ($_GET) { ?>
            <!-- Report Details -->
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <?php if (has_permission(VIEW, 'report', 'mis')) { ?>
                            <h6 class="card-header d-flex align-items-center">
                                <i class="fa fa-money font-30 mr-10"></i>
                                <?php echo $this->lang->line('credit'); ?> <?php echo $this->lang->line('report'); ?>
                            </h6>
                        <?php } ?>
                        <div class="button-list">
                            <a href="<?php echo site_url('report/mis/credit_pdf/?type=' . $type . '&date=' . $date . '&reference_id=' . $reference_id . '&created_by=' . $created_by); ?>" class="btn btn-success btn-xs">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('pdf'); ?> <?php echo $this->lang->line('generate'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-wrap">
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered mb-0">
                                    <thead>
                                        <tr>
                                            <th colspan="3" class="bg-success text-white text-center text-uppercase"><?php echo $this->lang->line('income'); ?></th>
                                            <th colspan="3" class="bg-danger text-white text-center text-uppercase"><?php echo $this->lang->line('expense'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td width="25%"><?php echo $this->lang->line('department'); ?></td>
                                            <td width="10%"><?php echo $this->lang->line('quantity'); ?></td>
                                            <td width="15%"><?php echo $this->lang->line('amount'); ?></td>
                                            <td width="25%"><?php echo $this->lang->line('department'); ?></td>
                                            <td width="10%"><?php echo $this->lang->line('quantity'); ?></td>
                                            <td width="15%"><?php echo $this->lang->line('amount'); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('opd'); ?></td>
                                            <td><?php echo $opd_income->total_opd_quantity ?? 0; ?></td>
                                            <td><?php echo $opd_income->total_opd_income ?? 0; ?></td>
                                            <td><?php echo $this->lang->line('opd'); ?></td>
                                            <td><?php echo $opd_expense->total_opd_quantity ?? 0; ?></td>
                                            <td><?php echo $opd_expense->total_opd_expense ?? 0; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('ipd'); ?></td>
                                            <td><?php echo $ipd_income->total_ipd_quantity ?? 0; ?></td>
                                            <td><?php echo $ipd_income->total_ipd_income ?? 0; ?></td>
                                            <td><?php echo $this->lang->line('ipd'); ?></td>
                                            <td><?php echo $ipd_expense->total_ipd_quantity ?? 0; ?></td>
                                            <td><?php echo $ipd_expense->total_ipd_expense ?? 0; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('diagnostic'); ?></td>
                                            <td><?php echo $diagnostic_income->total_diagnostic_quantity ?? 0; ?></td>
                                            <td><?php echo $diagnostic_income->total_diagnostic_income ?? 0; ?></td>
                                            <td><?php echo $this->lang->line('diagnostic'); ?></td>
                                            <td><?php echo $diagnostic_expense->total_diagnostic_quantity ?? 0; ?></td>
                                            <td><?php echo $diagnostic_expense->total_diagnostic_expense ?? 0; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('pharmacy'); ?></td>
                                            <td></td>
                                            <td></td>
                                            <td><?php echo $this->lang->line('surgeon'); ?></td>
                                            <td><?php echo $surgeon_expense->total_surgeon_quantity ?? 0; ?></td>
                                            <td><?php echo $surgeon_expense->total_surgeon_expense ?? 0; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('ambulance'); ?></td>
                                            <td></td>
                                            <td></td>
                                            <td><?php echo $this->lang->line('anesthesia'); ?></td>
                                            <td><?php echo $anesthesia_expense->total_anesthesia_quantity ?? 0; ?></td>
                                            <td><?php echo $anesthesia_expense->total_anesthesia_expense ?? 0; ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php echo $this->lang->line('blood_bank'); ?></td>
                                            <td></td>
                                            <td></td>
                                            <td><?php echo $this->lang->line('assistant'); ?></td>
                                            <td><?php echo $assistant_expense->total_assistant_quantity ?? 0; ?></td>
                                            <td><?php echo $assistant_expense->total_assistant_expense ?? 0; ?></td>
                                        </tr>
                                    </tbody>
                                </table>

                                <!-- Other Table -->
                                <?php if (isset($reference_id) && $reference_id == 0 && isset($type) && $type == 0) { ?>
                                    <table class="table table-sm table-bordered mt-3 mb-0">
                                        <thead>
                                            <tr>
                                                <th width="50%" colspan="3" class="bg-success text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('income'); ?></th>
                                                <th width="50%" colspan="3" class="bg-danger text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('opd'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="3" style="vertical-align: top;">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $income_opd_quantity = 0;
                                                            $total_opd_income = 0;
                                                            foreach ($incomes as $obj) {
                                                                $ihe = $this->mis->get_income_head_opd_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                                                $income_opd_quantity += $ihe->total_head_income;
                                                                $total_opd_income += $ihe->total_head_income;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->income_head; ?></td>
                                                                    <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $income_opd_quantity; ?></th>
                                                                <th><?php echo $total_opd_income; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                                <td colspan="3">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $expenditure_opd_quantity = 0;
                                                            $total_opd_expenditure = 0;
                                                            foreach ($expenditures as $obj) {
                                                                $ehe = $this->mis->get_expenditure_head_opd_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                                                $expenditure_opd_quantity += $ehe->total_expenditure_quantity;
                                                                $total_opd_expenditure += $ehe->total_expenditure_expense;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->expenditure_head; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $expenditure_opd_quantity; ?></th>
                                                                <th><?php echo $total_opd_expenditure; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <!-- IPD -->
                                    <table class="table table-sm table-bordered mt-3 mb-0">
                                        <thead>
                                            <tr>
                                                <th width="50%" colspan="3" class="bg-success text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('income'); ?></th>
                                                <th width="50%" colspan="3" class="bg-danger text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('ipd'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="3" style="vertical-align: top;">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $income_ipd_quantity = 0;
                                                            $total_ipd_income = 0;
                                                            foreach ($incomes as $obj) {
                                                                $ihe = $this->mis->get_income_head_ipd_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                                                $income_ipd_quantity += $ihe->total_head_income;
                                                                $total_ipd_income += $ihe->total_head_income;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->income_head; ?></td>
                                                                    <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $income_ipd_quantity; ?></th>
                                                                <th><?php echo $total_ipd_income; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                                <td colspan="3">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $expenditure_ipd_quantity = 0;
                                                            $total_ipd_expenditure = 0;
                                                            foreach ($expenditures as $obj) {
                                                                $ehe = $this->mis->get_expenditure_head_ipd_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                                                $expenditure_ipd_quantity += $ehe->total_expenditure_quantity;
                                                                $total_ipd_expenditure += $ehe->total_expenditure_expense;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->expenditure_head; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $expenditure_ipd_quantity; ?></th>
                                                                <th><?php echo $total_ipd_expenditure; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                    <!-- OTHER -->
                                    <table class="table table-sm table-bordered mt-3 mb-0">
                                        <thead>
                                            <tr>
                                                <th width="50%" colspan="3" class="bg-success text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('income'); ?></th>
                                                <th width="50%" colspan="3" class="bg-danger text-center text-uppercase text-white"><?php echo $this->lang->line('other'); ?> <?php echo $this->lang->line('expense'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="3" style="vertical-align: top;">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('income_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $income_other_quantity = 0;
                                                            $total_other_income = 0;
                                                            foreach ($incomes as $obj) {
                                                                $ihe = $this->mis->get_income_head_other_income($obj->income_head_id, $form_date, $to_date, $created_by);
                                                                $income_other_quantity += $ihe->total_head_income;
                                                                $total_other_income += $ihe->total_head_income;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->income_head; ?></td>
                                                                    <td><?php echo $ihe->total_income_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ihe->total_head_income ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $income_other_quantity; ?></th>
                                                                <th><?php echo $total_other_income; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                                <td colspan="3">
                                                    <table class="table table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th width="25%"><strong><?php echo $this->lang->line('expenditure_head'); ?></strong></th>
                                                                <th width="10%"><strong><?php echo $this->lang->line('quantity'); ?></strong></th>
                                                                <th width="15%"><strong><?php echo $this->lang->line('amount'); ?></strong></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php
                                                            $expenditure_other_quantity = 0;
                                                            $total_other_expenditure = 0;
                                                            foreach ($expenditures as $obj) {
                                                                $ehe = $this->mis->get_expenditure_head_other_expense($obj->expenditure_head_id, $form_date, $to_date, $created_by);
                                                                $expenditure_other_quantity += $ehe->total_expenditure_quantity;
                                                                $total_other_expenditure += $ehe->total_expenditure_expense;
                                                            ?>
                                                                <tr>
                                                                    <td><?php echo $obj->expenditure_head; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_quantity ?? 0; ?></td>
                                                                    <td><?php echo $ehe->total_expenditure_expense ?? 0; ?></td>
                                                                </tr>
                                                            <?php } ?>
                                                        </tbody>
                                                        <tfoot>
                                                            <tr>
                                                                <th align="right"><?php echo $this->lang->line('total'); ?></th>
                                                                <th><?php echo $expenditure_other_quantity; ?></th>
                                                                <th><?php echo $total_other_expenditure; ?></th>
                                                            </tr>
                                                        </tfoot>
                                                    </table>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                <?php } else { ?>
                                    <?php
                                    $total_opd_income = 0;
                                    $total_ipd_income = 0;
                                    $total_other_income = 0;

                                    $total_opd_expenditure = 0;
                                    $total_ipd_expenditure = 0;
                                    $total_other_expenditure = 0;
                                    ?>
                                <?php } ?>
                                <?php

                                $total_income = $total_opd_income + $total_ipd_income + $total_other_income;

                                $total_expenditure = $total_opd_expenditure + $total_ipd_expenditure + $total_other_expenditure;
                                ?>
                                <table class="table table-sm table-bordered mt-4" style="width: 50%; margin: 0 auto;">
                                    <tbody>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Income</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php $total_grand_income = ($opd_income->total_opd_income + $ipd_income->total_ipd_income + $diagnostic_income->total_diagnostic_income + $total_income); ?>
                                                <?php echo number_format(($opd_income->total_opd_income + $ipd_income->total_ipd_income + $diagnostic_income->total_diagnostic_income + $total_income), 2); ?>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Expense</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php $total_grand_expense = ($opd_expense->total_opd_expense + $ipd_expense->total_ipd_expense + $diagnostic_expense->total_diagnostic_expense + $surgeon_expense->total_surgeon_expense + $anesthesia_expense->total_anesthesia_expense + $assistant_expense->total_assistant_expense + $total_expenditure); ?>
                                                <?php echo number_format(($opd_expense->total_opd_expense + $ipd_expense->total_ipd_expense + $diagnostic_expense->total_diagnostic_expense + $surgeon_expense->total_surgeon_expense + $anesthesia_expense->total_anesthesia_expense + $assistant_expense->total_assistant_expense + $total_expenditure), 2); ?>
                                            </th>
                                        </tr>
                                        <tr>
                                            <th class="text-right font-weight-600">Total Hospital Balance</th>
                                            <th class="text-left font-weight-600">
                                                <?php echo $this->global_setting->currency_symbol; ?>
                                                <?php echo number_format(($total_grand_income - $total_grand_expense), 2); ?>
                                            </th>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Daterangepicker -->
<link href="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>moment/min/moment.min.js"></script>
<script src="<?php echo VENDOR_URL; ?>daterangepicker/daterangepicker.js"></script>

<!-- Select2 -->
<link href="<?php echo VENDOR_URL; ?>select2/dist/css/select2.min.css" rel="stylesheet" type="text/css" />
<script src="<?php echo VENDOR_URL; ?>select2/dist/js/select2.full.min.js"></script>

<style>
    .select2-container .select2-selection--single {
        height: calc(2.25rem + 4px) !important;
    }

    .select2-container--default .select2-search--dropdown .select2-search__field {
        color: #324148;
        border-width: 2px;
        border-color: #e0e3e4;
        padding: .375rem .75rem;
        height: calc(2.25rem + 4px);
    }

    .select2-container--default .select2-selection--single .select2-selection__arrow b {
        margin-top: 5px;
    }
</style>
<script>
    $(".select2").select2();
    $('#range').daterangepicker({
        autoUpdateInput: false,
        startDate: new Date(),
        endDate: moment(),
        showDropdowns: true,
        minYear: 1901,
        locale: {
            format: 'YYYY/MM/DD',
        },
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Tomorrow': [moment().subtract(-1, 'days'), moment().subtract(-1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Year': [moment().startOf('year'), moment().endOf('year')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
        }
    });

    $('input[id="range"]').on('apply.daterangepicker', function(ev, picker) {
        $(this).val(picker.startDate.format('YYYY/MM/DD') + ' - ' + picker.endDate.format('YYYY/MM/DD'));
    });

    $('input[id="range"]').on('cancel.daterangepicker', function(ev, picker) {
        $(this).val('');
    });
</script>