<!DOCTYPE html>
<html>

<head>
    <title>Marketing</title>
    <style>
        body {
            font-family: "Time New Roman";
            font-size: 13px;
        }

        .page {
            width: 100%;
            margin: 0 auto;
        }

        .main_body {
            /* page-break-after: always; */
            display: block;
        }

        .table {
            width: 100%;
            border-collapse: collapse;
        }

        .info_table {
            margin-top: 20px;
        }

        .content {
            margin-top: 20px;
        }

        .table_content thead th {
            padding: 0;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .table_content tbody td {
            padding: 0 2px;
            vertical-align: middle;
            border: 1px solid #000;
            font-size: 12px;
        }

        .footer {
            margin-top: 100px;
        }
    </style>
</head>

<body>
    <div class="page">
        <div class="main_body">
            <table class="table" style="text-align: center;">
                <tbody>
                    <tr>
                        <td>
                            <h2 style="margin-bottom: 0; font-size: 28px;"><?php echo $this->global_setting->brand_title; ?></h2>
                        </td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->address; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->email; ?></b></td>
                    </tr>
                    <tr>
                        <td><b><?php echo $this->global_setting->phone; ?></b></td>
                    </tr>
                </tbody>
            </table>

            <!-- Content Start-->
            <h2 align="center">MARKETING REPORT</h2>
            <div class="info_table">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%" align="left">
                                <?php if ($this->input->get('created_by')) { ?>
                                    <b>Name:</b>
                                    <span style="font-size: 12px; margin: 0; padding: 0;"><?php echo $employee->employee; ?>, <?php echo $employee->designation; ?></span>
                                <?php } else { ?>
                                    <b>All:</b>
                                <?php } ?>
                            </td>
                            <td width="30%" align="right">
                                <b>Date:</b>
                                <span style="font-size: 12px;"><?php echo date('d/m/Y h:i A'); ?></span>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <!-- Content Start-->
            <div class="content">
                <table class="table table_content">
                    <thead>
                        <tr>
                            <th><?php echo $this->lang->line('sl_no'); ?></th>
                            <th><?php echo $this->lang->line('appointment_no'); ?></th>
                            <th><?php echo $this->lang->line('date'); ?></th>
                            <th><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></th>
                            <th><?php echo $this->lang->line('phone'); ?></th>
                            <th><?php echo $this->lang->line('doctor'); ?></th>
                            <th><?php echo $this->lang->line('reference'); ?></th>
                            <?php if ($commission == 1) { ?>
                                <th><?php echo $this->lang->line('commission'); ?></th>
                            <?php } ?>
                            <?php if ($type == 'opd') { ?>
                                <th><?php echo $this->lang->line('opd'); ?></th>
                            <?php } ?>

                            <?php if ($type == 'ipd') { ?>
                                <th><?php echo $this->lang->line('ipd'); ?></th>
                            <?php } ?>

                            <?php if ($type == 'test') { ?>
                                <th><?php echo $this->lang->line('billing'); ?></th>
                            <?php } ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $count = 1;
                        $total_opd_amount = 0;
                        $total_ipd_amount = 0;
                        $total_test_amount = 0;
                        $total_commission_amount = 0;
                        $total_payable_commission = 0;
                        $total_discount = 0;
                        if (isset($marketings) && !empty($marketings)) { ?>
                            <?php foreach ($marketings as $obj) {
                                if ($type == 'opd') {
                                    $total_opd_amount += $obj->doctor_charge;
                                } elseif ($type == 'ipd') {
                                    $total_ipd_amount += $obj->net_payable;
                                } else {
                                    $total_test_amount += $obj->net_payable;
                                    $total_commission_amount += $obj->commission_amount;
                                    $total_payable_commission += $obj->payable_commission;
                                    $total_discount += $obj->discount;
                                }
                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?php echo $obj->appointment_no; ?></td>
                                    <td><?php echo date('d F, Y', strtotime($obj->appointment_date)); ?></td>
                                    <td><?php echo $obj->patient_name; ?></td>
                                    <td><?php echo $obj->phone; ?></td>
                                    <td><?php echo $obj->doctor; ?></td>
                                    <td><?php echo $obj->reference; ?></td>
                                    <?php if ($commission == 1) { ?>
                                        <td>
                                            <?php echo number_format(($obj->payable_commission - $obj->discount), 0); ?> /
                                            <?php echo number_format($obj->commission_amount, 0); ?>
                                        </td>
                                    <?php } ?>
                                    <?php if ($type == 'opd') { ?>
                                        <td><?php echo $obj->doctor_charge; ?></td>
                                    <?php } ?>

                                    <?php if ($type == 'ipd') { ?>
                                        <td><?php echo $obj->net_payable; ?></td>
                                    <?php } ?>

                                    <?php if ($type == 'test') { ?>
                                        <td><?php echo $obj->net_payable; ?></td>
                                    <?php } ?>
                                </tr>
                            <?php } ?>
                            <?php if ($type == 'opd') { ?>
                                <tr>
                                    <td colspan="6" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total OPD Amount:</th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_opd_amount, 2); ?></th>
                                </tr>
                            <?php } ?>

                            <?php if ($type == 'ipd') { ?>
                                <tr>
                                    <td colspan="6" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total IPD Amount:</th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_ipd_amount, 2); ?></th>
                                </tr>
                            <?php } ?>

                            <?php if ($type == 'test' && $commission == 1) { ?>
                                <tr class="bg-transparent">
                                    <td colspan="7" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Commission Amount</td>
                                    <td colspan="2" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_commission_amount, 2); ?></td>
                                </tr>
                                <tr class="bg-transparent">
                                    <td colspan="7" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Payable Commission Amount</td>
                                    <td colspan="2" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_payable_commission - $total_discount, 2); ?></td>
                                </tr>
                                <tr>
                                    <td colspan="7" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Test Amount:</th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_test_amount, 2); ?></th>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="6" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;">Total Test Amount:</th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format($total_test_amount, 2); ?></th>
                                </tr>
                            <?php } ?>
                            <?php if ($type == 'test' && $commission == 1) { ?>
                                <tr>
                                    <td colspan="7" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;"><b>Total Amount:</b></th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format(($total_opd_amount + $total_ipd_amount + $total_test_amount), 2); ?></th>
                                </tr>
                            <?php } else { ?>
                                <tr>
                                    <td colspan="6" align="right" style="padding-right: 5px; border-bottom: 1px solid #000;"><b>Total Amount:</b></th>
                                    <td colspan="2" align="left" style="padding-left: 5px; border-bottom: 1px solid #000;"><?php echo number_format(($total_opd_amount + $total_ipd_amount + $total_test_amount), 2); ?></th>
                                </tr>
                            <?php }  ?>
                        <?php } else { ?>
                            <tr class="text-center">
                                <td colspan="8"><?php echo $this->lang->line('no_data_found'); ?></td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
            <!-- Content End -->
            <!-- Footer -->
            <div class="footer">
                <table class="table">
                    <tbody>
                        <tr>
                            <td width="70%">
                                <p style="margin-left: 10%;">
                                    <b>Prepared By:</b>
                                    <?php echo $this->session->userdata('name'); ?>
                                </p>
                            </td>
                            <td width="30%" align="center">
                                <p style="border-top: 1px dashed red; width: 30%; margin: 5px auto;"></p>
                                <b>Signature</b>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>

</html>