<!-- Breadcrumb -->
<nav class="hk-breadcrumb" aria-label="breadcrumb">
    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo site_url('dashboard'); ?>"><?php echo $this->lang->line('dashboard'); ?></a></li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo $this->lang->line('manufacturer'); ?></li>
    </ol>
</nav>
<!-- /Breadcrumb -->

<!-- Container -->
<div class="container">
    <!-- Title -->
    <div class="hk-pg-header">
        <h4 class="hk-pg-title">
            <span class="pg-title-icon"><i class="fa fa-arrow-circle-o-down"></i></span>
            <?php echo $this->lang->line('manage_manufacturer'); ?>
        </h4>
    </div>
    <!-- /Title -->

    <!-- Row -->
    <div class="row">
        <!-- col-xl-12 -->
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <?php if (has_permission(EDIT, 'pharmacy', 'manufacturer')) { ?>
                        <h6 class="card-header d-flex align-items-center">
                            <i class="fa fa-industry font-30 mr-10"></i>
                            <?php echo $this->lang->line('edit'); ?> <?php echo $this->lang->line('manufacturer'); ?>
                        </h6>
                    <?php } ?>
                    <?php if (has_permission(VIEW, 'pharmacy', 'manufacturer')) { ?>
                        <div class="align-items-center">
                            <a href="<?php echo site_url('pharmacy/manufacturer'); ?>" class="btn btn-xs btn-primary">
                                <i class="fa fa-list font-12 mr-5"></i>
                                <?php echo $this->lang->line('manufacturer'); ?> <?php echo $this->lang->line('list'); ?>
                            </a>
                        </div>
                    <?php } ?>
                </div>

                <?php echo form_open_multipart(site_url('pharmacy/manufacturer/edit/' . $manufacturer->id), array('name' => 'edit', 'id' => 'edit', 'class' => 'needs-validation', 'novalidate' => 'novalidate'), ''); ?>
                <div class="card-body">
                    <div class="form-row">
                        <div class="col-md-4 mb-10">
                            <label for="name"><?php echo $this->lang->line('manufacturer'); ?> <?php echo $this->lang->line('name'); ?></label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($manufacturer->name) ?  $manufacturer->name : ''; ?>" placeholder="<?php echo $this->lang->line('manufacturer'); ?> <?php echo $this->lang->line('name'); ?>" required>
                            <div class="valid-feedback">
                                <?php echo $this->lang->line('looks_good'); ?>
                            </div>
                            <div class="invalid-feedback">
                                <?php echo $this->lang->line('required_field'); ?>
                            </div>
                            <small id="name" class="form-text text-muted">
                                <?php echo form_error('name'); ?>
                            </small>
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="phone"><?php echo $this->lang->line('phone'); ?></label>
                            <input type="text" class="form-control" name="phone" id="phone" value="<?php echo isset($manufacturer->phone) ?  $manufacturer->phone : ''; ?>" placeholder="<?php echo $this->lang->line('phone'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="email"><?php echo $this->lang->line('email'); ?></label>
                            <input type="email" class="form-control" name="email" id="email" value="<?php echo isset($manufacturer->email) ?  $manufacturer->email : ''; ?>" placeholder="<?php echo $this->lang->line('email'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="fax"><?php echo $this->lang->line('fax'); ?></label>
                            <input type="text" class="form-control" name="fax" id="fax" value="<?php echo isset($manufacturer->fax) ?  $manufacturer->fax : ''; ?>" placeholder="<?php echo $this->lang->line('fax'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="web"><?php echo $this->lang->line('web'); ?></label>
                            <input type="text" class="form-control" name="web" id="web" value="<?php echo isset($manufacturer->web) ?  $manufacturer->web : ''; ?>" placeholder="<?php echo $this->lang->line('web'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="established"><?php echo $this->lang->line('established'); ?></label>
                            <input type="number" min="0" class="form-control" name="established" id="established" value="<?php echo isset($manufacturer->established) ?  $manufacturer->established : ''; ?>" placeholder="<?php echo $this->lang->line('established'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="market_share"><?php echo $this->lang->line('market_share'); ?></label>
                            <input type="text" class="form-control" name="market_share" id="market_share" value="<?php echo isset($manufacturer->market_share) ?  $manufacturer->market_share : ''; ?>" placeholder="<?php echo $this->lang->line('market_share'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="growth"><?php echo $this->lang->line('growth'); ?></label>
                            <input type="text" class="form-control" name="growth" id="growth" value="<?php echo isset($manufacturer->growth) ?  $manufacturer->growth : ''; ?>" placeholder="<?php echo $this->lang->line('growth'); ?>">
                        </div>
                        <div class="col-md-2 mb-10">
                            <label for="sort_by"><?php echo $this->lang->line('sort_by'); ?></label>
                            <input type="number" class="form-control" name="sort_by" id="sort_by" value="<?php echo isset($manufacturer->sort_by) ?  $manufacturer->sort_by : ''; ?>" placeholder="<?php echo $this->lang->line('sort_by'); ?>">
                        </div>
                        <div class="col-md-1 mt-40">
                            <div class="custom-control custom-checkbox checkbox-cyan">
                            <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" <?php echo $manufacturer->status ? 'checked' : ''; ?>>
                                <label class="custom-control-label" for="status"><?php echo $this->lang->line('status'); ?></label>
                            </div>
                        </div>
                        <div class="col-md-4 mb-10">
                            <label for="address"><?php echo $this->lang->line('address'); ?></label>
                            <input type="text" class="form-control" name="address" id="address" value="<?php echo isset($manufacturer->address) ?  $manufacturer->address : ''; ?>" placeholder="<?php echo $this->lang->line('address'); ?>">
                        </div>
                        <div class="col-md-5 mb-10">
                            <label for="headquarter"><?php echo $this->lang->line('headquarter'); ?></label>
                            <input type="text" class="form-control" name="headquarter" id="headquarter" value="<?php echo isset($manufacturer->headquarter) ?  $manufacturer->headquarter : ''; ?>" placeholder="<?php echo $this->lang->line('headquarter'); ?>">
                        </div>
                        <div class="col-md-3 mb-10">
                            <label for="logo"><?php echo $this->lang->line('logo'); ?></label>
                            <div class="fileinput fileinput-new input-group" data-provides="fileinput">
                                <div class="input-group-prepend">
                                    <span class="input-group-text">Upload</span>
                                </div>
                                <div class="form-control text-truncate" data-trigger="fileinput">
                                    <i class="glyphicon glyphicon-file fileinput-exists"></i>
                                    <span class="fileinput-filename"></span>
                                </div>
                                <span class="input-group-append">
                                    <span class=" btn btn-primary btn-file">
                                        <span class="fileinput-new">Select file</span>
                                        <span class="fileinput-exists">Change</span>
                                        <input type="file" name="logo">
                                    </span>
                                    <a href="#" class="btn btn-secondary fileinput-exists" data-dismiss="fileinput">Remove</a>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('google_map'); ?></span>
                                </div>
                                <textarea class="form-control" name="google_map" id="google_map" aria-label="<?php echo $this->lang->line('google_map'); ?>"><?php echo isset($manufacturer->google_map) ?  $manufacturer->google_map : ''; ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <label for="about_us_en"><?php echo $this->lang->line('about'); ?> <?php echo $this->lang->line('english'); ?></label>
                            <textarea class="form-control tinymce" name="about_us_en" id="about_us_en" placeholder="<?php echo $this->lang->line('about'); ?> <?php echo $this->lang->line('english'); ?>"><?php echo isset($manufacturer->about_us_en) ?  $manufacturer->about_us_en : ''; ?></textarea>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <label for="about_us_bn"><?php echo $this->lang->line('about'); ?> <?php echo $this->lang->line('bengali'); ?></label>
                            <textarea class="form-control tinymce" name="about_us_bn" id="about_us_bn" placeholder="<?php echo $this->lang->line('about'); ?> <?php echo $this->lang->line('bengali'); ?>"><?php echo isset($manufacturer->about_us_bn) ?  $manufacturer->about_us_bn : ''; ?></textarea>
                        </div>
                        <div class="col-md-12 mt-10 mb-10">
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><?php echo $this->lang->line('remark'); ?></span>
                                </div>
                                <textarea class="form-control" name="note" id="note" aria-label="<?php echo $this->lang->line('remark'); ?>"><?php echo isset($manufacturer->note) ?  $manufacturer->note : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Card Footer -->
                <div class="card-footer pt-0">
                    <div class="button-list">
                        <input type="hidden" name="id" value="<?php echo $manufacturer->id; ?>">
                        <a class="btn btn-gradient-danger" href="<?php echo site_url('pharmacy/manufacturer'); ?>"><?php echo $this->lang->line('cancel'); ?></a>
                        <button class="btn btn-gradient-primary" type="submit"><?php echo $this->lang->line('update'); ?></button>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
    <!-- /Row -->
</div>
<!-- /Container -->


<!-- Tinymce JavaScript -->
<script src="<?php echo VENDOR_URL; ?>tinymce/tinymce.min.js"></script>
<script>
    $(function() {
        "use strict";
        tinymce.init({
            selector: '.tinymce',
            height: 200,
            plugins: [
                'advlist autolink lists link image charmap print preview anchor',
                'searchreplace visualblocks code fullscreen',
                'insertdatetime media table contextmenu paste code'
            ],
            toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image',
        });
    });
</script>