<div class="table-wrap">
    <div class="table-responsive">
        <table class="table table-sm text-white">
            <tbody>
                <tr>
                    <td><?php echo $this->lang->line('patient'); ?> <?php echo $this->lang->line('name'); ?></td>
                    <td><?php echo $surgeon->patient_name; ?></td>
                    <td><?php echo $this->lang->line('patient_id'); ?></td>
                    <td><?php echo $surgeon->patient_unique_id; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('surgeon'); ?></td>
                    <td><?php echo $surgeon->doctor; ?></td>
                    <td><?php echo $this->lang->line('surgeon'); ?> <?php echo $this->lang->line('charge'); ?></td>
                    <td><?php echo $surgeon->charge; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('status'); ?></td>
                    <td>
                        <?php if ($surgeon->surgeon_status == 'complete') { ?>
                            <span class="badge badge-success"><?php echo $this->lang->line('complete'); ?></span>
                        <?php } elseif ($surgeon->surgeon_status == 'rejected') { ?>
                            <span class="badge badge-danger"><?php echo $this->lang->line('rejected'); ?></span>
                        <?php } elseif ($surgeon->surgeon_status == 'pending') { ?>
                            <span class="badge badge-info"><?php echo $this->lang->line('pending'); ?></span>
                        <?php } else { ?>
                            <span class="badge badge-warning"><?php echo $this->lang->line('cancel'); ?></span>
                        <?php } ?>
                    </td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d/m/Y h:i A', strtotime($surgeon->date)); ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('instruction'); ?></td>
                    <td><?php echo $surgeon->instruction; ?></td>
                    <td><?php echo $this->lang->line('remark'); ?></td>
                    <td><?php echo $surgeon->note; ?></td>
                </tr>
                <tr>
                    <td><?php echo $this->lang->line('created_by'); ?></td>
                    <td><?php echo $surgeon->created_by; ?></td>
                    <td><?php echo $this->lang->line('date'); ?></td>
                    <td><?php echo date('d F, Y h:i A', strtotime($surgeon->created_at)); ?></td>
                </tr>
                <?php if ($this->session->userdata('role_id') == SUPER_ADMIN || !empty(custom_permission('modified_by'))) { ?>
                    <tr>
                        <td><?php echo $this->lang->line('modified_by'); ?></td>
                        <td><?php echo $surgeon->modified_by; ?></td>
                        <td><?php echo $this->lang->line('date'); ?></td>
                        <td><?php echo $surgeon->modified_by ? date('d F, Y h:i A', strtotime($surgeon->modified_at)) : ''; ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>