<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Bed_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_floor_list($limit, $offset, $search, $count) {
        $this->db->select('F.*');
        $this->db->from('floors AS F');
        if ($search) {
            $this->db->like('F.name', $search);
            $this->db->or_like('F.bn_name', $search);
            $this->db->or_like('F.note', $search);
            $this->db->or_like('F.created_at', $search);
        }
        $this->db->order_by('F.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_floor_name($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('floors')->num_rows();
    }

    public function get_bed_group_list($limit, $offset, $search, $count) {
        $this->db->select('B.*, F.name as floor');
        $this->db->from('bed_groups AS B');
        $this->db->join('floors AS F', 'F.id = B.floor_id', 'left');
        if ($search) {
            $this->db->like('B.name', $search);
            $this->db->or_like('B.bn_name', $search);
            $this->db->or_like('B.note', $search);
            $this->db->or_like('B.created_at', $search);
            $this->db->or_like('F.name', $search);
            $this->db->or_like('F.bn_name', $search);
        }
        $this->db->order_by('B.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_group_name($floor_id, $name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('floor_id', $floor_id);
        $this->db->where('name', $name);
        return $this->db->get('bed_groups')->num_rows();
    }

    public function get_bed_type_list($limit, $offset, $search, $count) {
        $this->db->select('T.*');
        $this->db->from('bed_types AS T');
        if ($search) {
            $this->db->like('T.name', $search);
            $this->db->or_like('T.bn_name', $search);
            $this->db->or_like('T.note', $search);
            $this->db->or_like('T.created_at', $search);
        }
        $this->db->order_by('T.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check_type_name($name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('name', $name);
        return $this->db->get('bed_types')->num_rows();
    }

    public function get_bed_list($limit, $offset, $search, $count) {
        $this->db->select('B.*, BT.name as type, BG.name as group');
        $this->db->from('beds AS B');
        $this->db->join('bed_types AS BT', 'BT.id = B.type_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = B.group_id', 'left');
        if ($search) {
            $this->db->like('B.name', $search);
            $this->db->or_like('B.bn_name', $search);
            $this->db->or_like('B.note', $search);
            $this->db->or_like('B.created_at', $search);
            $this->db->or_like('BT.name', $search);
            $this->db->or_like('BG.name', $search);
        }
        $this->db->order_by('B.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    public function get_bed_status_list($limit, $offset, $search, $count) {
        $this->db->select('B.*, BT.name as type, BG.name as group, F.name as floor');
        $this->db->from('beds AS B');
        $this->db->join('bed_types AS BT', 'BT.id = B.type_id', 'left');
        $this->db->join('bed_groups AS BG', 'BG.id = B.group_id', 'left');
        $this->db->join('floors AS F', 'F.id = BG.floor_id', 'left');
        if ($search) {
            $this->db->like('B.name', $search);
            $this->db->or_like('B.bn_name', $search);
            $this->db->or_like('B.note', $search);
            $this->db->or_like('B.created_at', $search);
            $this->db->or_like('BT.name', $search);
            $this->db->or_like('BG.name', $search);
            $this->db->or_like('F.name', $search);
        }
        $this->db->order_by('B.id', 'DESC');
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
        return array();
    }

    function duplicate_check($type_id, $group_id, $name, $id = null) {
        if ($id) {
            $this->db->where_not_in('id', $id);
        }
        $this->db->where('type_id', $type_id);
        $this->db->where('group_id', $group_id);
        $this->db->where('name', $name);
        return $this->db->get('beds')->num_rows();
    }
}
