<?php

defined('BASEPATH') or exit('No direct script access allowed');

/* * *****************Ipd.php**********************************
 * @product name    : Hospital Management System
 * @type            : Class
 * @class name      : Ipd
 * @description     : Manage ipd.
 * @author          : South Bangla IT Zone Team
 * @url             : http://hms.sbitzone.com
 * @support         : rabibd.it@gmail.com
 * @copyright       : South Bangla IT Zone Team
 * ********************************************************** */

class Ipd extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Ipd_Model', 'ipd', true);
    }

    /*****************Function index**********************************
     * @type            : Function
     * @function name   : index
     * @description     : Load "IPD List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function index() {

        check_permission(VIEW);

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('ipd') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/index', $this->data);
    }


    /*****************Function charge**********************************
     * @type            : Function
     * @function name   : charge
     * @description     : Load "Charge List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function charge() {

        check_permission(VIEW);
        $search = trim($this->input->get('search'));
        $config = array();
        $config = get_pagination(ADMIN_PER_PAGE);
        if ($search) {
            $config['base_url'] = site_url('hospital/ipd/charge/?search=') . $search;
        } else {
            $config['base_url'] = current_url();
        }
        if ($this->input->get('page')) {
            $sgm = (int) trim($this->input->get('page'));
            $offset = $config['per_page'] * ($sgm - 1);
        } else {
            $offset = 0;
        }

        $config['total_rows'] = $this->ipd->get_charge_list($config['per_page'], $offset, $search, $count = TRUE);
        $this->pagination->initialize($config);
        $this->data['charges'] = $this->ipd->get_charge_list($config['per_page'], $offset, $search, $count = FALSE);
        $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
        $this->data['search'] = $search;

        $this->data['list'] = TRUE;
        $this->layout->title($this->lang->line('charge') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/charge/index', $this->data);
    }

    /*****************Function add_charge**********************************
     * @type            : Function
     * @function name   : add_charge
     * @description     : Load "Add new Charge" user interface
     *                    and process to store "charges" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function add_charge() {

        check_permission(ADD);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_charge_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');
            $this->form_validation->set_rules('price', $this->lang->line('price'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['code'] = $this->input->post('code');
                $data['price'] = $this->input->post('price');
                $data['commission'] = $this->input->post('commission');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->ipd->insert('charges', $data);
                if ($insert_id) {
                    create_log('Has been created a IPD charge : ' . $data['name']);
                    success($this->lang->line('insert_success'));
                    redirect('hospital/ipd/charge');
                } else {
                    error($this->lang->line('insert_failed'));
                    redirect('hospital/ipd/add_charge');
                }
            } else {
                $this->data = $_POST;
            }
        }

        $this->data['add'] = TRUE;
        $this->layout->title($this->lang->line('add') . ' ' . $this->lang->line('charge') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/charge/add', $this->data);
    }

    /*****************Function edit_charge**********************************
     * @type            : Function
     * @function name   : edit_charge
     * @description     : Load "Edit new charge" user interface
     *                    and process to store "charges" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function edit_charge($id = NULL) {

        check_permission(EDIT);

        if ($_POST) {

            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required|callback_charge_name');
            $this->form_validation->set_rules('bn_name', $this->lang->line('bn_name'), 'trim|required');
            $this->form_validation->set_rules('price', $this->lang->line('price'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['code'] = $this->input->post('code');
                $data['price'] = $this->input->post('price');
                $data['commission'] = $this->input->post('commission');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();

                $updated = $this->ipd->update('charges', $data, array('id' => $this->input->post('id')));
                if ($updated) {
                    create_log('Has been updated a IPD charge : ' . $data['name']);
                    success($this->lang->line('update_success'));
                    redirect('hospital/ipd/charge');
                } else {
                    error($this->lang->line('update_failed'));
                    redirect('hospital/ipd/edit_charge/' . $this->input->post('id'));
                }
            } else {
                $this->data['charge'] = $this->ipd->get_single('charges', array('id' => $this->input->post('id')));
            }
        } else {
            if ($id) {
                $this->data['charge'] = $this->ipd->get_single('charges', array('id' => $id));
                if (!$this->data['charge']) {
                    redirect('hospital/ipd/charge');
                }
            }
        }

        $this->data['edit'] = TRUE;
        $this->layout->title($this->lang->line('edit') . ' ' . $this->lang->line('charge') . ' | ' . $this->global_setting->brand_title);
        $this->layout->view('ipd/charge/edit', $this->data);
    }

    /*****************Function charge_name**********************************
     * @type            : Function
     * @function name   : charge_name
     * @description     : Unique check for "Charge Name" data/value
     *
     * @param           : null
     * @return          : boolean true/false
     * ********************************************************** */
    public function charge_name() {
        if ($this->input->post('id') == '') {
            $charge = $this->ipd->duplicate_check_charge_name($this->input->post('name'));
            if ($charge) {
                $this->form_validation->set_message('charge_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else if ($this->input->post('id') != '') {
            $charge = $this->ipd->duplicate_check_charge_name($this->input->post('name'), $this->input->post('id'));
            if ($charge) {
                $this->form_validation->set_message('charge_name', $this->lang->line('already_exist'));
                return FALSE;
            } else {
                return TRUE;
            }
        } else {
            return TRUE;
        }
    }

    /*****************Function delete_charge**********************************
     * @type            : Function
     * @function name   : delete_charge
     * @description     : delete "IPD Charge" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_charge($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/ipd/charge');
        }

        $charge = $this->ipd->get_single('charges', array('id' => $id));

        if ($this->ipd->delete('charges', array('id' => $id))) {
            create_log('Has been deleted a IPD Charge : ' . $charge->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }


    /*****************Function package**********************************
     * @type            : Function
     * @function name   : package
     * @description     : Load "Package List" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */
    public function package($package_id = null, $id = null) {

        if (isset($package_id) && $package_id > 0) {
            if ($_POST) {
                $this->load->library('form_validation');
                $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
                $this->form_validation->set_rules('name', $this->lang->line('name'), 'trim|required');

                if ($this->form_validation->run() === TRUE) {
                    $data['package_id'] = $this->input->post('package_id');
                    $data['name'] = $this->input->post('name');
                    $data['bn_name'] = $this->input->post('bn_name');
                    $data['price'] = $this->input->post('price');
                    $data['commission'] = $this->input->post('commission');
                    $data['code'] = $this->input->post('code');
                    $data['status'] = $this->input->post('status') ? $this->input->post('status') : 0;

                    if ($this->input->post('id')) {
                        $data['modified_at'] = date('Y-m-d H:i:s');
                        $data['modified_by'] = logged_in_user_id();
                        $updated_id = $this->ipd->update('package_items', $data, array('id' => $this->input->post('id')));
                        if ($updated_id) {
                            create_log('Has been updated a package items : ' . $data['name']);
                            success($this->lang->line('update_success'));
                            redirect('hospital/ipd/package/' . $package_id);
                        } else {
                            error($this->lang->line('update_failed'));
                            redirect('hospital/ipd/package');
                        }
                    } else {
                        $data['created_at'] = date('Y-m-d H:i:s');
                        $data['created_by'] = logged_in_user_id();

                        $insert_id = $this->ipd->insert('package_items', $data);
                        if ($insert_id) {
                            create_log('Has been created a package items : ' . $data['name']);
                            success($this->lang->line('insert_success'));
                            redirect('hospital/ipd/package/' . $package_id);
                        } else {
                            error($this->lang->line('insert_failed'));
                            redirect('hospital/ipd/package');
                        }
                    }
                } else {
                    $this->data = $_POST;
                }
            }

            $this->data['package_item'] = $this->ipd->get_single('package_items', array('id' => $id));
            $this->data['package_items'] = $this->ipd->get_list('package_items', array('package_id' => $package_id), '', '', '', 'sort_by', 'ASC');

            $this->data['list'] = TRUE;
            $this->layout->title($this->lang->line('manage_package') . ' | ' . $this->global_setting->brand_title);
            $this->layout->view('hospital/ipd/package/package-item', $this->data);
        } else {

            check_permission(VIEW);

            $search = trim($this->input->get('search'));
            $config = array();
            $config = get_pagination(ADMIN_PER_PAGE);
            if ($search) {
                $config['base_url'] = site_url('hospital/ipd/package/?search=') . $search;
            } else {
                $config['base_url'] = current_url();
            }
            if ($this->input->get('page')) {
                $sgm = (int) trim($this->input->get('page'));
                $offset = $config['per_page'] * ($sgm - 1);
            } else {
                $offset = 0;
            }

            $config['total_rows'] = $this->ipd->get_package_list($config['per_page'], $offset, $search, $count = TRUE);
            $this->pagination->initialize($config);
            $this->data['packages'] = $this->ipd->get_package_list($config['per_page'], $offset, $search, $count = FALSE);
            $this->data['sl_count'] = ($this->input->get('page') == 0 ? 1 : (($this->input->get('page') - 1) * $config["per_page"] + 1));
            $this->data['search'] = $search;

            $this->data['list'] = TRUE;
            $this->layout->title($this->lang->line('package') . ' ' . $this->lang->line('list') . ' | ' . $this->global_setting->brand_title);
            $this->layout->view('ipd/package/index', $this->data);
        }
    }

    public function save_package() {
        $data = json_decode($_POST['data']);
        function parseJsonArray($jsonArray, $parentID = 0) {
            $return = array();
            foreach ($jsonArray as $subArray) {
                $returnSubSubArray = array();
                if (isset($subArray->children)) {
                    $returnSubSubArray = parseJsonArray($subArray->children, $subArray->id);
                }
                $return[] = array('id' => $subArray->id, 'parentID' => $parentID);
                $return = array_merge($return, $returnSubSubArray);
            }
            return $return;
        }
        $readbleArray = parseJsonArray($data);
        $i = 0;
        foreach ($readbleArray as $row) {
            $i++;
            $this->ipd->update('package_items', array('parent_id' => $row['parentID'], 'sort_by' => $i), array('id' => $row['id']));
        }
    }

    /*****************Function add_package**********************************
     * @type            : Function
     * @function name   : add_package
     * @description     : Load "Add New Package" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function add_package() {
        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name') . ' ' . $this->lang->line('name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status');

                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $insert_id = $this->ipd->insert('ipd_packages', $data);
                if ($insert_id) {
                    create_log('Has been created a IPD Package : ' . $data['name']);
                }
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('insert_success'));
            } else {
                $this->data = $_POST;
                $msg = array(
                    'name' => form_error('name')
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }
            echo json_encode($array);
        }
    }

    /*****************Function get_package**********************************
     * @type            : Function
     * @function name   : get_package
     * @description     : Load "Single Package List" user interface
     *                    and process to store "packages" into database
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function get_package($id) {
        $package = $this->ipd->get_single('ipd_packages', array('id' => $id));
        echo json_encode($package);
    }

    /*****************Function edit_package**********************************
     * @type            : Function
     * @function name   : edit_package
     * @description     : Load "Edit Package" user interface
     *
     * @param           : null
     * @return          : null
     * ********************************************************** */

    public function edit_package() {
        if ($_POST) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('<div class="error-message" style="color: red;">', '</div>');
            $this->form_validation->set_rules('name', $this->lang->line('name') . ' ' . $this->lang->line('name'), 'trim|required');

            if ($this->form_validation->run() === TRUE) {
                $data['name'] = $this->input->post('name');
                $data['bn_name'] = $this->input->post('bn_name');
                $data['note'] = $this->input->post('note');
                $data['sort_by'] = $this->input->post('sort_by');
                $data['status'] = $this->input->post('status');

                $data['created_at'] = date('Y-m-d H:i:s');
                $data['created_by'] = logged_in_user_id();

                $updated_id = $this->ipd->update('ipd_packages', $data, array('id' =>  $this->input->post('id')));
                if ($updated_id) {
                    create_log('Has been updated a IPD Package : ' . $data['name']);
                }
                $array = array('status' => 'success', 'error' => '', 'message' => $this->lang->line('update_success'));
            } else {
                $this->data = $_POST;
                $msg = array(
                    'name' => form_error('name')
                );
                $array = array('status' => 'failed', 'error' => $msg, 'message' => '');
            }
            echo json_encode($array);
        }
    }

    /*****************Function delete_package**********************************
     * @type            : Function
     * @function name   : delete_package
     * @description     : delete "Delete Package" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_package($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/ipd/package');
        }

        $item = $this->ipd->get_single('ipd_packages', array('id' => $id));
        if ($this->ipd->delete('ipd_packages', array('id' => $id))) {
            $this->ipd->delete('package_items', array('package_id' => $item->id));
            create_log('Has been deleted a package : ' . $item->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }

    /*****************Function delete_package_item**********************************
     * @type            : Function
     * @function name   : delete_package_item
     * @description     : delete "Delete Package Item" data from database
     *
     * @param           : $id integer value
     * @return          : null
     * ********************************************************** */
    public function delete_package_item($id = null) {

        check_permission(DELETE);

        if (!is_numeric($id)) {
            error($this->lang->line('unexpected_error'));
            redirect('hospital/ipd/package');
        }

        $item = $this->ipd->get_single('package_items', array('id' => $id));
        if ($this->ipd->delete('package_items', array('id' => $id))) {
            create_log('Has been deleted a package item : ' . $item->name);
            success($this->lang->line('delete_success'));
        } else {
            error($this->lang->line('delete_failed'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
}
