<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Visitor_Model extends MY_Model {

    function __construct() {
        parent::__construct();
    }
    public function get_visitor_list($limit, $offset, $search, $create_form_date, $create_to_date, $profession, $pregnancy, $treatment, $card, $package, $land, $operation, $test, $created_by, $count) {
        $this->db->select('V.*, VP.name as visitor_purpose, VP.bn_name as bn_name_up, UN.bn_name as bn_name_un, VL.bn_name as bn_name_vl, C.name as created_by');
        $this->db->from('visitors AS V');
        $this->db->join('visitor_purposes AS VP', 'VP.id = V.purpose_id', 'left');
      	$this->db->join('unions AS UN', 'UN.id = V.union_id', 'left');
      	$this->db->join('villages AS VL', 'VL.id = V.village_id', 'left');
      	$this->db->join('employees AS C', 'C.user_id = V.created_by', 'left');

      
        if($this->session->userdata('role_id') !== SUPER_ADMIN  && $this->session->userdata('role_id') !== ADMIN && $this->session->userdata('role_id') !== SUPERVISOR){
           $this->db->where('V.created_by', $this->session->userdata('user_id'));
        }
      	if ($create_form_date && $create_to_date) {
            $this->db->where("DATE(V.created_at) BETWEEN '$create_form_date' AND '$create_to_date'");
        }
        if ($profession) {
            $this->db->where('V.profession', $profession);
        }
      	if ($pregnancy) {
            $this->db->where('V.yes_no2', $pregnancy);
        }
      	if ($treatment) {
            $this->db->where('V.yes_no3', $treatment);
        }
      	if ($card) {
            $this->db->where('V.yes_no4', $card);
        }
      	if ($package) {
            $this->db->where('V.yes_no5', $package);
        }
      	if ($land) {
            $this->db->where('V.yes_no7', $land);
        }
      	if ($operation) {
            $this->db->where('V.yes_no8', $operation);
        }
      	if ($test) {
            $this->db->where('V.yes_no9', $test);
        }
      	if ($created_by) {
            $this->db->where('V.created_by', $created_by);
        }
      	if ($search) {
            $this->db->like('V.phone', $search);
            $this->db->or_like('V.name', $search);
            $this->db->or_like('V.date', $search);
            $this->db->or_like('VP.name', $search);
        }
        $this->db->order_by('V.id', 'DESC');
      	
        if ($count) {
            return $this->db->count_all_results();
        } else {
            $this->db->limit($limit, $offset);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result();
            }
        }
    }
  	public function get_employee_list() {
        $this->db->select('E.*');
        $this->db->from('employees AS E');
        $this->db->join('users AS U', 'U.id = E.user_id', 'left');
        $this->db->where('E.status', '1');
        if ($this->session->userdata('role_id') == SUPER_ADMIN) {
            $this->db->where_in('U.role_id', array(SUPER_ADMIN, ADMIN, ACCOUNTANT, RECEPTIONIST, PATHOLOGIST, RADIOLOGIST, NURSE, STAFF, MARKETING, PHARMACIST));
        } else {
            $this->db->where_in('U.role_id', array(ADMIN, ACCOUNTANT, RECEPTIONIST, PATHOLOGIST, RADIOLOGIST, NURSE, STAFF, MARKETING, PHARMACIST));
        }
        $this->db->order_by('E.id ', 'DESC');
        return $this->db->get()->result();
    }
}
